/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws;

import com.sun.istack.tools.MaskingClassLoader;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.xjc.api.util.ToolsJarNotFoundException;
import com.sun.xml.bind.util.Which;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker {
    public static String[] maskedPackages = new String[]{"com.sun.istack.tools.", "com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.tools.ws.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind.", "com.sun.xml.ws."};

    static int invoke(String mainClass, String[] args) throws Throwable {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = Invoker.class.getClassLoader();
            if (Arrays.asList(args).contains("-Xendorsed")) {
                cl = Invoker.createClassLoader(cl);
            } else {
                if (!Invoker.checkIfLoading21API()) {
                    if (Service.class.getClassLoader() == null) {
                        System.err.println(WscompileMessages.INVOKER_NEED_ENDORSED());
                    } else {
                        System.err.println(WscompileMessages.WRAPPER_TASK_LOADING_20_API(Which.which(Service.class)));
                    }
                    int n = -1;
                    return n;
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                Invoker.findToolsJar(cl, urls);
                if (urls.size() > 0) {
                    ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
                    cl = new MaskingClassLoader(cl, mask);
                    cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
                    cl = new ParallelWorldClassLoader(cl, "");
                }
            }
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> compileTool = cl.loadClass(mainClass);
            Constructor<?> ctor = compileTool.getConstructor(OutputStream.class);
            Object tool = ctor.newInstance(System.out);
            Method runMethod = compileTool.getMethod("run", String[].class);
            boolean r = (Boolean)runMethod.invoke(tool, new Object[]{args});
            int n = r ? 0 : 1;
            return n;
        }
        catch (ToolsJarNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcc);
        }
        return -1;
    }

    public static boolean checkIfLoading21API() {
        try {
            Service.class.getMethod("getPort", Class.class, WebServiceFeature[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public static ClassLoader createClassLoader(ClassLoader cl) throws ClassNotFoundException, MalformedURLException, ToolsJarNotFoundException {
        URL[] urls = Invoker.findIstackAPIs(cl);
        if (urls.length == 0) {
            return cl;
        }
        ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
        if (urls.length > 1) {
            mask.add("javax.xml.bind.");
            mask.add("javax.xml.ws.");
        }
        cl = new MaskingClassLoader(cl, mask);
        cl = new URLClassLoader(urls, cl);
        cl = new ParallelWorldClassLoader(cl, "");
        return cl;
    }

    private static URL[] findIstackAPIs(ClassLoader cl) throws ClassNotFoundException, MalformedURLException, ToolsJarNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Service.class.getClassLoader() == null) {
            URL res = cl.getResource("javax/xml/ws/EndpointReference.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAX-WS 2.1 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl(res));
            res = cl.getResource("javax/xml/bind/annotation/XmlSeeAlso.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAXB 2.1 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl(res));
        }
        Invoker.findToolsJar(cl, urls);
        return urls.toArray(new URL[urls.size()]);
    }

    private static void findToolsJar(ClassLoader cl, List<URL> urls) throws ToolsJarNotFoundException, MalformedURLException {
        try {
            Class.forName("com.sun.tools.javac.Main", false, cl);
            Class.forName("com.sun.tools.apt.Main", false, cl);
        }
        catch (ClassNotFoundException e) {
            File jreHome = new File(System.getProperty("java.home"));
            File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new ToolsJarNotFoundException(toolsJar);
            }
            urls.add(toolsJar.toURL());
        }
    }
}

