/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.handler.HandlerProcessor;
import com.sun.xml.ws.handler.HandlerTube;
import com.sun.xml.ws.handler.LogicalMessageContextImpl;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import com.sun.xml.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.ws.handler.XMLHandlerProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;

public class ClientLogicalHandlerTube
extends HandlerTube {
    private WSBinding binding;
    private List<LogicalHandler> logicalHandlers;

    public ClientLogicalHandlerTube(WSBinding binding, WSDLPort port, Tube next) {
        super(next, port);
        this.binding = binding;
    }

    public ClientLogicalHandlerTube(WSBinding binding, Tube next, HandlerTube cousinTube) {
        super(next, cousinTube);
        this.binding = binding;
    }

    private ClientLogicalHandlerTube(ClientLogicalHandlerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
    }

    boolean isHandlerChainEmpty() {
        return this.logicalHandlers.isEmpty();
    }

    public void close(MessageContext msgContext) {
        if (this.requestProcessingSucessful && this.cousinTube != null) {
            this.cousinTube.closeCall(msgContext);
        }
        if (this.processor != null) {
            this.closeLogicalHandlers(msgContext);
        }
    }

    public void closeCall(MessageContext msgContext) {
        this.closeLogicalHandlers(msgContext);
    }

    private void closeLogicalHandlers(MessageContext msgContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(msgContext, this.processor.getIndex(), 0);
            this.processor.setIndex(-1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(msgContext, this.logicalHandlers.size() - 1, 0);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner cloner) {
        return new ClientLogicalHandlerTube(this, cloner);
    }

    void setUpProcessor() {
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        List<LogicalHandler> logicalSnapShot = ((BindingImpl)this.binding).getHandlerConfig().getLogicalHandlers();
        if (!logicalSnapShot.isEmpty()) {
            this.logicalHandlers.addAll(logicalSnapShot);
            this.processor = this.binding.getSOAPVersion() == null ? new XMLHandlerProcessor(this, this.binding, this.logicalHandlers) : new SOAPHandlerProcessor(true, this, this.binding, this.logicalHandlers);
        }
    }

    MessageUpdatableContext getContext(Packet packet) {
        return new LogicalMessageContextImpl(this.binding, packet);
    }

    boolean callHandlersOnRequest(MessageUpdatableContext context, boolean isOneWay) {
        boolean handlerResult;
        try {
            handlerResult = this.processor.callHandlersRequest(HandlerProcessor.Direction.OUTBOUND, context, !isOneWay);
        }
        catch (WebServiceException wse) {
            this.remedyActionTaken = true;
            throw wse;
        }
        catch (RuntimeException re) {
            this.remedyActionTaken = true;
            throw new WebServiceException((Throwable)re);
        }
        if (!handlerResult) {
            this.remedyActionTaken = true;
        }
        return handlerResult;
    }

    void callHandlersOnResponse(MessageUpdatableContext context, boolean handleFault) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.INBOUND, context, handleFault);
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (RuntimeException re) {
            throw new WebServiceException((Throwable)re);
        }
    }
}

