/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.marshall.RegionNotFoundException;

public abstract class Marshaller {
    protected boolean useRegionBasedMarshalling;
    protected RegionManager regionManager;
    protected boolean defaultInactive;
    private static Log log = LogFactory.getLog((Class)Marshaller.class);
    private ConcurrentHashMap transactions = new ConcurrentHashMap(16);

    protected void init(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling) {
        this.useRegionBasedMarshalling = useRegionBasedMarshalling;
        this.defaultInactive = defaultInactive;
        this.regionManager = manager;
    }

    public abstract void objectToStream(Object var1, ObjectOutputStream var2) throws Exception;

    public abstract Object objectFromStream(ObjectInputStream var1) throws Exception;

    protected String extractFqnFromMethodCall(JBCMethodCall call) {
        JBCMethodCall c0 = (JBCMethodCall)((Object)call.getArgs()[0]);
        return this.extractFqn(c0);
    }

    protected String extractFqnFromListOfMethodCall(JBCMethodCall call) {
        Object[] args = call.getArgs();
        JBCMethodCall c0 = (JBCMethodCall)((Object)((List)args[0]).get(0));
        return this.extractFqn(c0);
    }

    protected String extractFqn(JBCMethodCall methodCall) {
        if (methodCall == null) {
            throw new NullPointerException("method call is null");
        }
        Method meth = methodCall.getMethod();
        String fqnStr = null;
        Object[] args = methodCall.getArgs();
        switch (methodCall.getMethodId()) {
            case 10: 
            case 18: {
                List modifications = (List)args[1];
                fqnStr = this.extractFqn((JBCMethodCall)((Object)modifications.get(0)));
                boolean one_phase_commit = (Boolean)args[args.length - 1];
                if (one_phase_commit) break;
                this.transactions.put(args[0], (Object)fqnStr);
                break;
            }
            case 11: 
            case 12: {
                fqnStr = (String)this.transactions.remove(args[0]);
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 35: {
                fqnStr = args[0].toString();
                break;
            }
            case 34: {
                fqnStr = args[1].toString();
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 13: 
            case 22: {
                fqnStr = this.extractFqn((JBCMethodCall)((Object)args[0]));
                break;
            }
            default: {
                if (MethodDeclarations.isCrudMethod(meth)) {
                    fqnStr = args[1].toString();
                    break;
                }
                if (MethodDeclarations.isGetMethod(methodCall.getMethodId())) {
                    fqnStr = args[0].toString();
                    break;
                }
                throw new IllegalArgumentException("Marshaller.extractFqn(): Unknown method call id: " + methodCall.getMethodId());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("extract(): received " + (Object)((Object)methodCall) + "extracted fqn: " + fqnStr));
        }
        return fqnStr;
    }

    protected Region getRegion(String fqnString) {
        Fqn fqn = Fqn.fromString(fqnString);
        if (BuddyManager.isBackupFqn(fqn)) {
            fqn = fqn.getFqnChild(2, fqn.size());
        }
        return this.regionManager.getRegion(fqn);
    }

    public void registerClassLoader(String fqn, ClassLoader cl) throws RegionNameConflictException {
        if (!this.useRegionBasedMarshalling) {
            return;
        }
        Region existing = this.regionManager.getRegion(fqn);
        if (existing == null) {
            this.regionManager.createRegion(fqn, cl, this.defaultInactive);
        } else {
            existing.setClassLoader(cl);
        }
    }

    public void unregisterClassLoader(String fqn) throws RegionNotFoundException {
        if (!this.useRegionBasedMarshalling) {
            return;
        }
        Region region = this.regionManager.getRegion(fqn);
        if (region != null) {
            region.setClassLoader(null);
        }
    }

    public ClassLoader getClassLoader(String fqn) throws RegionNotFoundException {
        if (!this.useRegionBasedMarshalling) {
            return null;
        }
        ClassLoader result = null;
        Region region = this.regionManager.getRegion(fqn);
        if (region != null) {
            result = region.getClassLoader();
        }
        return result;
    }

    public void activate(String fqn) throws RegionNameConflictException {
        if (!this.useRegionBasedMarshalling) {
            return;
        }
        if (this.regionManager.hasRegion(fqn)) {
            Region region = this.regionManager.getRegion(fqn);
            if (!this.defaultInactive && region.getClassLoader() == null) {
                this.regionManager.removeRegion(fqn);
            } else {
                region.activate();
            }
        } else if (this.defaultInactive) {
            this.regionManager.createRegion(fqn, null, false);
        } else {
            this.regionManager.checkConflict(fqn);
        }
    }

    public void inactivate(String fqn) throws RegionNameConflictException {
        if (!this.useRegionBasedMarshalling) {
            return;
        }
        if (this.regionManager.hasRegion(fqn)) {
            Region region = this.regionManager.getRegion(fqn);
            if (this.defaultInactive && region.getClassLoader() == null) {
                this.regionManager.removeRegion(fqn);
            } else {
                region.inactivate();
            }
        } else if (!this.defaultInactive) {
            this.regionManager.createRegion(fqn, null, true);
        } else {
            this.regionManager.checkConflict(fqn);
        }
    }

    public boolean isInactive(String fqn) {
        if (!this.useRegionBasedMarshalling) {
            return false;
        }
        boolean result = this.defaultInactive;
        Region region = this.regionManager.getRegion(fqn);
        if (region != null) {
            result = region.isInactive();
        }
        return result;
    }
}

