/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.PojoCache;

public class ObjectUtil {
    static Log log = LogFactory.getLog((String)ObjectUtil.class.getName());

    public static boolean isReachable(PojoCache cache, Object originalObject, Object thisObject) throws CacheException {
        HashSet objSet = new HashSet();
        return ObjectUtil.isReachableInner(cache, originalObject, thisObject, objSet);
    }

    public static boolean isReachableInner(PojoCache cache, Object originalObject, Object thisObject, Set objSet) throws CacheException {
        if (!(originalObject instanceof Advised)) {
            throw new RuntimeException("ObjectUtil.isReachable(): originalObject is not Advised.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("isReachable(): current object: " + originalObject + " this object: " + thisObject));
        }
        if (originalObject.equals(thisObject)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"isReachable(): object found reachable.");
            }
            return true;
        }
        if (objSet.contains(originalObject)) {
            return false;
        }
        objSet.add(originalObject);
        CachedType type = cache.getCachedType(originalObject.getClass());
        Iterator i = type.getFieldsIterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            Object value = null;
            try {
                value = field.get(originalObject);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", e);
            }
            CachedType fieldType = cache.getCachedType(field.getType());
            if (fieldType.isImmediate()) continue;
            if (value instanceof Map) {
                Set set = ((Map)value).keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (!ObjectUtil.isReachableInner(cache, it.next(), thisObject, objSet)) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    if (!ObjectUtil.isReachableInner(cache, it.next(), thisObject, objSet)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof Advised) || !ObjectUtil.isReachableInner(cache, value, thisObject, objSet)) continue;
            return true;
        }
        return false;
    }

    public static String getIndirectFqn(Fqn fqn) {
        return ObjectUtil.getIndirectFqn(fqn.toString());
    }

    public static String getIndirectFqn(String fqn) {
        return fqn.replace('/', '_');
    }
}

