/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;
import org.apache.tomcat.util.threads.ThreadWithAttributes;
import org.jboss.logging.Logger;

public class ThreadPool {
    private static Logger log = Logger.getLogger(ThreadPool.class);
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util.threads.res");
    private static boolean logfull = true;
    public static final int MAX_THREADS = 200;
    public static final int MAX_THREADS_MIN = 10;
    public static final int MAX_SPARE_THREADS = 50;
    public static final int MIN_SPARE_THREADS = 4;
    public static final int WORK_WAIT_TIMEOUT = 60000;
    protected ControlRunnable[] pool = null;
    protected MonitorRunnable monitor;
    protected int maxThreads = 200;
    protected int minSpareThreads = 4;
    protected int maxSpareThreads = 50;
    protected int currentThreadCount = 0;
    protected int currentThreadsBusy = 0;
    protected boolean stopThePool = false;
    protected boolean isDaemon = true;
    protected Hashtable threads = new Hashtable();
    protected Vector listeners = new Vector();
    protected String name = "TP";
    protected int sequence = 1;
    protected int threadPriority = 5;

    public static ThreadPool createThreadPool(boolean jmx) {
        return new ThreadPool();
    }

    public synchronized void start() {
        this.stopThePool = false;
        this.currentThreadCount = 0;
        this.currentThreadsBusy = 0;
        this.adjustLimits();
        this.pool = new ControlRunnable[this.maxThreads];
        this.openThreads(this.minSpareThreads);
        if (this.maxSpareThreads < this.maxThreads) {
            this.monitor = new MonitorRunnable(this);
        }
    }

    public MonitorRunnable getMonitor() {
        return this.monitor;
    }

    public synchronized void setThreadPriority(int threadPriority) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getClass().getName() + ": setPriority(" + threadPriority + "): here."));
        }
        if (threadPriority < 1) {
            throw new IllegalArgumentException("new priority < MIN_PRIORITY");
        }
        if (threadPriority > 10) {
            throw new IllegalArgumentException("new priority > MAX_PRIORITY");
        }
        this.threadPriority = threadPriority;
        Enumeration currentThreads = this.getThreads();
        Thread t = null;
        while (currentThreads.hasMoreElements()) {
            t = (Thread)currentThreads.nextElement();
            t.setPriority(threadPriority);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    public int getCurrentThreadsBusy() {
        return this.currentThreadsBusy;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public static int getDebug() {
        return 0;
    }

    public void setDaemon(boolean b) {
        this.isDaemon = b;
    }

    public boolean getDaemon() {
        return this.isDaemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getSequence() {
        return this.sequence++;
    }

    public void addThread(Thread t, ControlRunnable cr) {
        this.threads.put(t, cr);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ThreadPoolListener tpl = (ThreadPoolListener)this.listeners.elementAt(i);
            tpl.threadStart(this, t);
        }
    }

    public void removeThread(Thread t) {
        this.threads.remove(t);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ThreadPoolListener tpl = (ThreadPoolListener)this.listeners.elementAt(i);
            tpl.threadEnd(this, t);
        }
    }

    public void addThreadPoolListener(ThreadPoolListener tpl) {
        this.listeners.addElement(tpl);
    }

    public Enumeration getThreads() {
        return this.threads.keys();
    }

    public void run(Runnable r) {
        ControlRunnable c = this.findControlRunnable();
        c.runIt(r);
    }

    public void runIt(ThreadPoolRunnable r) {
        if (null == r) {
            throw new NullPointerException();
        }
        ControlRunnable c = this.findControlRunnable();
        c.runIt(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControlRunnable findControlRunnable() {
        ControlRunnable c = null;
        if (this.stopThePool) {
            throw new IllegalStateException();
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            while (this.currentThreadsBusy == this.currentThreadCount) {
                if (this.currentThreadCount < this.maxThreads) {
                    int toOpen = this.currentThreadCount + this.minSpareThreads;
                    this.openThreads(toOpen);
                    continue;
                }
                ThreadPool.logFull(log, this.currentThreadCount, this.maxThreads);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)"Unexpected exception", (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finished waiting: CTC=" + this.currentThreadCount + ", CTB=" + this.currentThreadsBusy));
                }
                if (!this.stopThePool) continue;
            }
            if (0 == this.currentThreadCount || this.stopThePool) {
                throw new IllegalStateException();
            }
            int pos = this.currentThreadCount - this.currentThreadsBusy - 1;
            c = this.pool[pos];
            this.pool[pos] = null;
            ++this.currentThreadsBusy;
        }
        return c;
    }

    private static void logFull(Logger loghelper, int currentThreadCount, int maxThreads) {
        if (logfull) {
            log.error((Object)sm.getString("threadpool.busy", new Integer(currentThreadCount), new Integer(maxThreads)));
            logfull = false;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("All threads are busy " + currentThreadCount + " " + maxThreads));
        }
    }

    public synchronized void shutdown() {
        if (!this.stopThePool) {
            this.stopThePool = true;
            if (this.monitor != null) {
                this.monitor.terminate();
                this.monitor = null;
            }
            for (int i = 0; i < this.currentThreadCount - this.currentThreadsBusy; ++i) {
                try {
                    this.pool[i].terminate();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"Ignored exception while shutting down thread pool", t);
                }
            }
            this.currentThreadCount = 0;
            this.currentThreadsBusy = 0;
            this.pool = null;
            this.notifyAll();
        }
    }

    protected synchronized void checkSpareControllers() {
        if (this.stopThePool) {
            return;
        }
        if (this.currentThreadCount - this.currentThreadsBusy > this.maxSpareThreads) {
            int toFree = this.currentThreadCount - this.currentThreadsBusy - this.maxSpareThreads;
            for (int i = 0; i < toFree; ++i) {
                ControlRunnable c = this.pool[this.currentThreadCount - this.currentThreadsBusy - 1];
                c.terminate();
                this.pool[this.currentThreadCount - this.currentThreadsBusy - 1] = null;
                --this.currentThreadCount;
            }
        }
    }

    protected synchronized void returnController(ControlRunnable c) {
        if (0 == this.currentThreadCount || this.stopThePool) {
            c.terminate();
            return;
        }
        --this.currentThreadsBusy;
        this.pool[this.currentThreadCount - this.currentThreadsBusy - 1] = c;
        this.notify();
    }

    protected synchronized void notifyThreadEnd(ControlRunnable c) {
        --this.currentThreadsBusy;
        --this.currentThreadCount;
        this.notify();
    }

    protected void adjustLimits() {
        if (this.maxThreads <= 0) {
            this.maxThreads = 200;
        } else if (this.maxThreads < 10) {
            log.warn((Object)sm.getString("threadpool.max_threads_too_low", new Integer(this.maxThreads), new Integer(10)));
            this.maxThreads = 10;
        }
        if (this.maxSpareThreads >= this.maxThreads) {
            this.maxSpareThreads = this.maxThreads;
        }
        if (this.maxSpareThreads <= 0) {
            this.maxSpareThreads = 1 == this.maxThreads ? 1 : this.maxThreads / 2;
        }
        if (this.minSpareThreads > this.maxSpareThreads) {
            this.minSpareThreads = this.maxSpareThreads;
        }
        if (this.minSpareThreads <= 0) {
            this.minSpareThreads = 1 == this.maxSpareThreads ? 1 : this.maxSpareThreads / 2;
        }
    }

    protected void openThreads(int toOpen) {
        if (toOpen > this.maxThreads) {
            toOpen = this.maxThreads;
        }
        for (int i = this.currentThreadCount; i < toOpen; ++i) {
            this.pool[i - this.currentThreadsBusy] = new ControlRunnable(this);
        }
        this.currentThreadCount = toOpen;
    }

    void log(String s) {
        log.info((Object)s);
    }

    public String threadStatusString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.threads.keySet().iterator();
        sb.append("<ul>");
        while (it.hasNext()) {
            sb.append("<li>");
            ThreadWithAttributes twa = (ThreadWithAttributes)it.next();
            sb.append(twa.getCurrentStage(this)).append(" ");
            sb.append(twa.getParam(this));
            sb.append("</li>\n");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String[] getThreadStatus() {
        String[] status = new String[this.threads.size()];
        Iterator it = this.threads.keySet().iterator();
        for (int i = 0; i < status.length && it.hasNext(); ++i) {
            ThreadWithAttributes twa = (ThreadWithAttributes)it.next();
            status[i] = twa.getCurrentStage(this);
        }
        return status;
    }

    public String[] getThreadParam() {
        String[] status = new String[this.threads.size()];
        Iterator it = this.threads.keySet().iterator();
        for (int i = 0; i < status.length && it.hasNext(); ++i) {
            ThreadWithAttributes twa = (ThreadWithAttributes)it.next();
            Object o = twa.getParam(this);
            status[i] = o == null ? null : o.toString();
        }
        return status;
    }

    public static interface ThreadPoolListener {
        public void threadStart(ThreadPool var1, Thread var2);

        public void threadEnd(ThreadPool var1, Thread var2);
    }

    public static class ControlRunnable
    implements Runnable {
        private ThreadPool p;
        private ThreadWithAttributes t;
        private ThreadPoolRunnable toRun = null;
        private Runnable toRunRunnable;
        private boolean shouldTerminate = false;
        private boolean shouldRun = false;
        private boolean noThData;

        ControlRunnable(ThreadPool p) {
            this.p = p;
            this.t = new ThreadWithAttributes(p, (Runnable)this);
            this.t.setDaemon(true);
            this.t.setName(p.getName() + "-Processor" + p.getSequence());
            this.t.setPriority(p.getThreadPriority());
            p.addThread(this.t, this);
            this.noThData = true;
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block24: {
                boolean _shouldRun = false;
                boolean _shouldTerminate = false;
                ThreadPoolRunnable _toRun = null;
                try {
                    while (true) {
                        try {
                            do {
                                ControlRunnable controlRunnable = this;
                                synchronized (controlRunnable) {
                                    while (!this.shouldRun && !this.shouldTerminate) {
                                        this.wait();
                                    }
                                    _shouldRun = this.shouldRun;
                                    _shouldTerminate = this.shouldTerminate;
                                    _toRun = this.toRun;
                                }
                                if (_shouldTerminate) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"Terminate");
                                    }
                                    break block24;
                                }
                                try {
                                    if (this.noThData) {
                                        if (_toRun != null) {
                                            Object[] thData = _toRun.getInitData();
                                            this.t.setThreadData(this.p, thData);
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)"Getting new thread data");
                                            }
                                        }
                                        this.noThData = false;
                                    }
                                    if (!_shouldRun) continue;
                                    if (_toRun != null) {
                                        _toRun.runIt(this.t.getThreadData(this.p));
                                        continue;
                                    }
                                    if (this.toRunRunnable != null) {
                                        this.toRunRunnable.run();
                                        continue;
                                    }
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)"No toRun ???");
                                }
                                catch (Throwable t) {
                                    log.error((Object)sm.getString("threadpool.thread_error", t, this.toRun.toString()));
                                    _shouldTerminate = true;
                                    _shouldRun = false;
                                    this.p.notifyThreadEnd(this);
                                }
                                finally {
                                    if (_shouldRun) {
                                        this.shouldRun = false;
                                        this.p.returnController(this);
                                    }
                                }
                            } while (!_shouldTerminate);
                        }
                        catch (InterruptedException ie) {
                            log.error((Object)"Unexpected exception", (Throwable)ie);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.p.removeThread(Thread.currentThread());
                }
            }
        }

        public synchronized void runIt(Runnable toRun) {
            this.toRunRunnable = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public synchronized void runIt(ThreadPoolRunnable toRun) {
            this.toRun = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public void stop() {
            this.terminate();
        }

        public void kill() {
            this.t.stop();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }

    public static class MonitorRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        int interval = 60000;
        boolean shouldTerminate;

        MonitorRunnable(ThreadPool p) {
            this.p = p;
            this.start();
        }

        public void start() {
            this.shouldTerminate = false;
            this.t = new Thread(this);
            this.t.setDaemon(this.p.getDaemon());
            this.t.setName(this.p.getName() + "-Monitor");
            this.t.start();
        }

        public void setInterval(int i) {
            this.interval = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        MonitorRunnable monitorRunnable = this;
                        synchronized (monitorRunnable) {
                            this.wait(this.interval);
                        }
                        if (this.shouldTerminate) break block5;
                        this.p.checkSpareControllers();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected exception", t);
                    continue;
                }
                break;
            }
        }

        public void stop() {
            this.terminate();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }
}

