/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private SessionFactory sessionFactory;
    private PersistenceUnitTransactionType transactionType;
    private boolean discardOnClose;

    public EntityManagerFactoryImpl(SessionFactory sessionFactory, PersistenceUnitTransactionType transactionType, boolean discardOnClose) {
        this.sessionFactory = sessionFactory;
        this.transactionType = transactionType;
        this.discardOnClose = discardOnClose;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    public EntityManager createEntityManager(Map map) {
        return new EntityManagerImpl(this.sessionFactory, PersistenceContextType.EXTENDED, this.transactionType, this.discardOnClose, map);
    }

    public void close() {
        this.sessionFactory.close();
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

