/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslrmi;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SerializableSSLClientSocketFactory
extends RemotingRMIClientSocketFactory {
    private static final long serialVersionUID = 3242156275483606618L;
    private static Logger log = Logger.getLogger((Class)SerializableSSLClientSocketFactory.class);

    public SerializableSSLClientSocketFactory(InvokerLocator invokerLocator, int timeout, Map configuration) {
        super(invokerLocator, invokerLocator.getHost(), timeout, configuration);
        this.invokerLocator = invokerLocator;
        this.configuration = new HashMap(configuration);
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket s = super.createSocket(host, port);
        Object obj = this.configuration.get("handshakeCompletedListener");
        if (obj != null && obj instanceof HandshakeCompletedListener) {
            SSLSocket sslSocket = (SSLSocket)s;
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            this.establishHandshake(sslSocket, listener);
        }
        return s;
    }

    public SocketFactory retrieveSocketFactory(RemotingRMIClientSocketFactory.ComparableHolder holder) throws IOException {
        SocketFactory sf = (SocketFactory)socketFactories.get(this);
        if (sf == null) {
            try {
                Object obj;
                HashMap tempConfig = new HashMap(this.configuration);
                Map localConfig = (Map)configMaps.get(holder);
                if (localConfig != null) {
                    tempConfig.putAll(localConfig);
                }
                if (tempConfig.containsKey("customSocketFactory")) {
                    sf = (SocketFactory)tempConfig.get("customSocketFactory");
                } else {
                    SSLSocketBuilder socketBuilder = new SSLSocketBuilder(tempConfig);
                    socketBuilder.setUseSSLSocketFactory(false);
                    sf = socketBuilder.createSSLSocketFactory();
                    sf = AbstractInvoker.wrapSocketFactory(sf, tempConfig);
                }
                socketFactories.put(this, sf);
                if (localConfig != null && (obj = localConfig.get("handshakeCompletedListener")) != null) {
                    this.configuration.put("handshakeCompletedListener", obj);
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        return sf;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }
}

