/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javassist.util.proxy.MethodHandler;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.jboss.security.ssl.DomainServerSocketFactory;

class DomainServerSocket
implements MethodHandler,
HandshakeCompletedListener {
    private SSLServerSocket delegate;

    DomainServerSocket(SSLServerSocket delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object self, Method method, Method method1, Object[] args) throws Exception {
        Object rtn = null;
        if (method.getName().equals("accept")) {
            rtn = this.accept();
        } else {
            try {
                rtn = method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw e;
            }
        }
        return rtn;
    }

    public Socket accept() throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.accept();
        socket.addHandshakeCompletedListener(this);
        return socket;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        SSLSession session = event.getSession();
        String sessionID = null;
        byte[] id = session.getId();
        try {
            sessionID = new String(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            sessionID = new String(id);
        }
        DomainServerSocketFactory.putSSLSession(sessionID, session);
    }
}

