/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class UsersLoginModule
extends UsernamePasswordLoginModule {
    private String usersRsrcName = "users.properties";
    private Properties users;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String option = (String)options.get("usersProperties");
            if (option != null) {
                this.usersRsrcName = option;
            }
            this.loadUsers();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        if (this.users == null) {
            throw new LoginException("Missing users.properties file.");
        }
        return super.login();
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    protected String getUsersPassword() {
        String username = this.getUsername();
        String password = null;
        if (username != null) {
            password = this.users.getProperty(username, null);
        }
        return password;
    }

    private void loadUsers() throws IOException {
        this.users = this.loadProperties(this.usersRsrcName);
    }

    private Properties loadProperties(String propertiesName) throws IOException {
        Properties bundle = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(propertiesName);
        if (url == null) {
            throw new IOException("Properties file " + propertiesName + " not found");
        }
        this.log.trace((Object)("Properties file=" + url));
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("Properties file " + propertiesName + " not avilable");
        }
        bundle = new Properties();
        bundle.load(is);
        return bundle;
    }
}

