/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.util.ArrayList;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class JavassistUtils {
    public static CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];

    public static CtMethod[] getMethodsWithName(CtClass clazz, String name) {
        CtMethod[] methods = clazz.getMethods();
        return JavassistUtils.getMethodsWithName(methods, name);
    }

    public static CtMethod[] getDeclaredMethodsWithName(CtClass clazz, String name) {
        CtMethod[] methods = clazz.getDeclaredMethods();
        return JavassistUtils.getMethodsWithName(methods, name);
    }

    private static CtMethod[] getMethodsWithName(CtMethod[] methods, String name) {
        ArrayList<CtMethod> foundMethods = new ArrayList<CtMethod>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            foundMethods.add(methods[i]);
        }
        return foundMethods.toArray(new CtMethod[foundMethods.size()]);
    }

    public static boolean isSubclassOrImplements(CtClass clazz, CtClass lookingFor) throws NotFoundException {
        if (clazz == null) {
            return false;
        }
        if (clazz.equals(lookingFor)) {
            return true;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        CtClass[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!JavassistUtils.isSubclassOrImplements(interfaces[i], lookingFor)) continue;
            return true;
        }
        return JavassistUtils.isSubclassOrImplements(clazz.getSuperclass(), lookingFor);
    }

    public static String getNullOrZeroInitialiser(CtClass clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(CtClass.booleanType)) {
                return "false";
            }
            if (clazz.equals(CtClass.charType)) {
                return "'\\0'";
            }
            if (clazz.equals(CtClass.byteType)) {
                return "(byte)0";
            }
            if (clazz.equals(CtClass.shortType)) {
                return "(short)0";
            }
            if (clazz.equals(CtClass.intType)) {
                return "(int)0";
            }
            if (clazz.equals(CtClass.longType)) {
                return "0L";
            }
            if (clazz.equals(CtClass.floatType)) {
                return "0.0f";
            }
            if (clazz.equals(CtClass.doubleType)) {
                return "0.0d";
            }
        } else {
            return "null";
        }
        return null;
    }
}

