/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sql.util;

import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlSqlInfo {
    protected static Log m_log = LogFactory.getLog(ControlSqlInfo.class);
    protected String m_monitorTypeId;
    protected String m_monitorId;

    public ControlSqlInfo(String monitorId, String monitorTypeId) {
        this.m_monitorId = monitorId;
        this.m_monitorTypeId = monitorTypeId;
    }

    public MonitorSqlInfo get() throws FinderException, NamingException {
        MonitorSqlInfoPK pk = new MonitorSqlInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
        MonitorSqlInfo sql = new MonitorSqlInfo();
        sql.setMonitorTypeId(this.m_monitorTypeId);
        sql.setMonitorId(this.m_monitorId);
        sql.setConnectionUrl(sqlLocal.getConnection_url());
        sql.setUser(sqlLocal.getConnection_user());
        sql.setPassword(sqlLocal.getConnection_password());
        sql.setQuery(sqlLocal.getQuery());
        sql.setJdbcDriver(sqlLocal.getJdbc_driver());
        return sql;
    }

    public boolean add(MonitorSqlInfo sql) throws CreateException, NamingException {
        MonitorSqlInfoUtil.getLocalHome().create(this.m_monitorTypeId, this.m_monitorId, sql.getConnectionUrl(), sql.getUser(), sql.getPassword(), sql.getQuery(), sql.getJdbcDriver());
        return true;
    }

    public boolean modify(MonitorSqlInfo sql) throws CreateException, FinderException, NamingException {
        MonitorSqlInfoPK pk = new MonitorSqlInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
        sqlLocal.setConnection_url(sql.getConnectionUrl());
        sqlLocal.setConnection_user(sql.getUser());
        sqlLocal.setConnection_password(sql.getPassword());
        sqlLocal.setQuery(sql.getQuery());
        sqlLocal.setJdbc_driver(sql.getJdbcDriver());
        return true;
    }

    public boolean delete() throws FinderException, RemoveException, NamingException {
        MonitorSqlInfoPK pk = new MonitorSqlInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
        sqlLocal.remove();
        return true;
    }
}

