/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpoint
extends AbstractExtensible
implements Endpoint {
    private Service service;
    private ObjectName name;
    private String shortName;
    private String urlPattern;
    private String targetBean;
    private Endpoint.EndpointState state;
    private RequestHandler requestHandler;
    private InvocationHandler invocationHandler;
    private LifecycleHandler lifecycleHandler;
    private EndpointMetrics metrics;
    private List<BindingCustomization> bindingCustomizsations = new ArrayList<BindingCustomization>();
    private String address;

    DefaultEndpoint(String targetBean) {
        this.targetBean = targetBean;
        this.state = Endpoint.EndpointState.UNDEFINED;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.assertEndpointSetterAccess();
        this.service = service;
    }

    public String getTargetBeanName() {
        return this.targetBean;
    }

    public void setTargetBeanName(String targetBean) {
        this.assertEndpointSetterAccess();
        this.targetBean = targetBean;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Class getTargetBeanClass() {
        Class<?> beanClass;
        if (this.targetBean == null) {
            throw new IllegalStateException("Target bean not set");
        }
        ClassLoader classLoader = this.service.getDeployment().getRuntimeClassLoader();
        if (classLoader == null) {
            classLoader = this.service.getDeployment().getInitialClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("Deployment classloader not set");
        }
        try {
            beanClass = classLoader.loadClass(this.targetBean);
        }
        catch (ClassNotFoundException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
        return beanClass;
    }

    public ObjectName getName() {
        return this.name;
    }

    public void setName(ObjectName name) {
        this.assertEndpointSetterAccess();
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.assertEndpointSetterAccess();
        this.shortName = shortName;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        this.assertEndpointSetterAccess();
        this.urlPattern = urlPattern;
    }

    public Endpoint.EndpointState getState() {
        return this.state;
    }

    public void setState(Endpoint.EndpointState state) {
        this.state = state;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.assertEndpointSetterAccess();
        this.requestHandler = handler;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void setLifecycleHandler(LifecycleHandler handler) {
        this.assertEndpointSetterAccess();
        this.lifecycleHandler = handler;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler handler) {
        this.assertEndpointSetterAccess();
        this.invocationHandler = handler;
    }

    public EndpointMetrics getEndpointMetrics() {
        return this.metrics;
    }

    public void setEndpointMetrics(EndpointMetrics metrics) {
        this.assertEndpointSetterAccess();
        metrics.setEndpoint((Endpoint)this);
        this.metrics = metrics;
    }

    public <T> T addAttachment(Class<T> clazz, Object obj) {
        this.assertEndpointSetterAccess();
        return (T)super.addAttachment(clazz, obj);
    }

    public <T> T removeAttachment(Class<T> key) {
        this.assertEndpointSetterAccess();
        return (T)super.removeAttachment(key);
    }

    public void removeProperty(String key) {
        this.assertEndpointSetterAccess();
        super.removeProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.assertEndpointSetterAccess();
        super.setProperty(key, value);
    }

    private void assertEndpointSetterAccess() {
        if (this.state == Endpoint.EndpointState.STARTED) {
            throw new IllegalStateException("Cannot modify endpoint properties in state: " + this.state);
        }
    }
}

