/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class NotificationFilterSupport
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = 6579080007561786969L;
    private Vector enabledTypes = new Vector();

    public synchronized void disableAllTypes() {
        this.enabledTypes = new Vector();
    }

    public synchronized void disableType(String type) {
        this.enabledTypes.removeElement(type);
    }

    public synchronized void enableType(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("null notification type");
        }
        if (!this.enabledTypes.contains(type)) {
            this.enabledTypes.addElement(type);
        }
    }

    public synchronized Vector getEnabledTypes() {
        return (Vector)this.enabledTypes.clone();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getName()).append(':');
        sb.append(" enabledTypes=").append(this.getEnabledTypes());
        return sb.toString();
    }

    public synchronized boolean isNotificationEnabled(Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("null notification");
        }
        String notificationType = notification.getType();
        Enumeration e = this.enabledTypes.elements();
        while (e.hasMoreElements()) {
            String type = (String)e.nextElement();
            if (!notificationType.startsWith(type)) continue;
            return true;
        }
        return false;
    }
}

