/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.jdbc.JDBCContext;
import org.jboss.ejb3.entity.ExtendedEntityManager;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.TransactionScopedEntityManager;
import org.jboss.ejb3.entity.hibernate.ExtendedSessionInvocationHandler;
import org.jboss.ejb3.entity.hibernate.TransactionScopedSessionInvocationHandler;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.injection.EncInjector;
import org.jboss.injection.ExtendedPersistenceContextInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.naming.Util;

public class PcEncInjector
implements EncInjector {
    private static final Class[] SESS_PROXY_INTERFACES = new Class[]{Session.class, SessionImplementor.class, JDBCContext.Context.class, EventSource.class};
    private String encName;
    private String unitName;
    private PersistenceContextType type;
    private Class injectionType;
    private String error;

    public PcEncInjector(String encName, String unitName, PersistenceContextType type, Class injectionType, String error) {
        this.encName = encName;
        this.unitName = unitName;
        this.type = type;
        this.injectionType = injectionType;
        this.error = error;
    }

    public void inject(InjectionContainer container) {
        Object entityManager;
        String error1 = this.error;
        ManagedEntityManagerFactory factory = null;
        try {
            factory = PersistenceUnitHandler.getManagedEntityManagerFactory(container, this.unitName);
        }
        catch (NameNotFoundException e) {
            error1 = error1 + " " + e.getMessage();
        }
        if (factory == null) {
            throw new RuntimeException(error1);
        }
        if (this.type == PersistenceContextType.EXTENDED) {
            Object extendedPc;
            if (!(container instanceof StatefulContainer)) {
                throw new RuntimeException("It is illegal to inject an EXTENDED PC into something other than a SFSB");
            }
            container.getInjectors().add(0, new ExtendedPersistenceContextInjector(factory));
            if (this.injectionType == null || this.injectionType.getName().equals(EntityManager.class.getName())) {
                extendedPc = new ExtendedEntityManager(factory.getKernelName());
            } else {
                ExtendedSessionInvocationHandler handler = new ExtendedSessionInvocationHandler(factory.getKernelName());
                extendedPc = Proxy.newProxyInstance(org.hibernate.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)handler);
            }
            try {
                Util.rebind((Context)container.getEnc(), (String)this.encName, (Object)extendedPc);
            }
            catch (NamingException e) {
                throw new RuntimeException(error1, e);
            }
        }
        if (this.injectionType == null || EntityManager.class.isAssignableFrom(this.injectionType)) {
            entityManager = new TransactionScopedEntityManager(factory);
        } else {
            TransactionScopedSessionInvocationHandler handler = new TransactionScopedSessionInvocationHandler(factory);
            entityManager = Proxy.newProxyInstance(org.hibernate.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)handler);
        }
        try {
            Util.rebind((Context)container.getEnc(), (String)this.encName, (Object)entityManager);
        }
        catch (NamingException e) {
            throw new RuntimeException(error1, e);
        }
    }
}

