/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import org.jboss.mx.util.QueryExpSupport;

class BetweenQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -2933597532866307444L;
    private ValueExp exp1;
    private ValueExp exp2;
    private ValueExp exp3;

    public BetweenQueryExp() {
    }

    public BetweenQueryExp(ValueExp test, ValueExp lower, ValueExp upper) {
        this.exp1 = test;
        this.exp2 = lower;
        this.exp3 = upper;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp calcTest = this.exp1.apply(name);
        ValueExp calcLower = this.exp2.apply(name);
        ValueExp calcUpper = this.exp3.apply(name);
        if (calcTest instanceof NumericValueExp && calcLower instanceof NumericValueExp && calcUpper instanceof NumericValueExp) {
            double valueTest = ((NumericValueExp)calcTest).getDoubleValue();
            double valueLower = ((NumericValueExp)calcLower).getDoubleValue();
            double valueUpper = ((NumericValueExp)calcUpper).getDoubleValue();
            return valueLower <= valueTest && valueTest <= valueUpper;
        }
        if (calcTest instanceof StringValueExp && calcLower instanceof StringValueExp && calcUpper instanceof StringValueExp) {
            String valueTest = calcTest.toString();
            String valueLower = calcLower.toString();
            String valueUpper = calcUpper.toString();
            return valueLower.compareTo(valueTest) <= 0 && valueUpper.compareTo(valueTest) >= 0;
        }
        throw new BadBinaryOpValueExpException(calcTest);
    }

    public void setMBeanServer(MBeanServer server) {
        QueryExpSupport.server.set(server);
    }

    public String toString() {
        return new String("(" + this.exp2.toString() + ") <= (" + this.exp1.toString() + ") <= (" + this.exp3.toString()) + ")";
    }
}

