/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusBean;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusDAO;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorStatusDAOImpl
implements CollectorStatusDAO {
    protected static Log m_log = LogFactory.getLog(CollectorStatusDAO.class);

    public void init() {
        m_log.trace((Object)"init CollectorStatusDAO");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(CollectorStatusPK pk, CollectorStatusBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM CC_COLLECTOR_STATUS WHERE COLLECTORID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.collectorID);
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "CollectorStatus data is not found.";
                    m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setCollectorID(res.getString("COLLECTORID"));
                ejb.setRunStatus(res.getShort("RUN_STATUS"));
                ejb.setErrorStatus(res.getShort("ERROR_STATUS"));
                ejb.setEndStatus(res.getShort("END_STATUS"));
                ejb.setCount(res.getLong("COUNT"));
                Timestamp timestamp = res.getTimestamp("LAST_COLLECT_DATE");
                if (timestamp != null) {
                    ejb.setLastCollectDate(new Date(timestamp.getTime()));
                } else {
                    ejb.setLastCollectDate(null);
                }
                Object var9_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end   : " + pk.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(CollectorStatusBean ejb) throws EJBException {
        m_log.debug((Object)("store() start :" + ejb.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "UPDATE CC_COLLECTOR_STATUS SET RUN_STATUS = ?,ERROR_STATUS = ?,END_STATUS = ?,COUNT = ?,LAST_COLLECT_DATE = ? WHERE COLLECTORID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setShort(1, (short)ejb.getRunStatus());
                stmt.setShort(2, (short)ejb.getErrorStatus());
                stmt.setShort(3, (short)ejb.getEndStatus());
                stmt.setLong(4, ejb.getCount());
                Date lastCollectDate = ejb.getLastCollectDate();
                if (lastCollectDate != null) {
                    stmt.setTimestamp(5, new Timestamp(lastCollectDate.getTime()));
                } else {
                    stmt.setTimestamp(5, null);
                }
                stmt.setString(6, ejb.getCollectorID());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end   :" + ejb.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(CollectorStatusPK pk) throws EJBException {
        m_log.debug((Object)("remove()  start: " + pk.getCollectorID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM CC_COLLECTOR_STATUS WHERE COLLECTORID = ? ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.collectorID);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.getCollectorID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CollectorStatusPK create(CollectorStatusBean ejb) throws CreateException, EJBException, DuplicateKeyException {
        m_log.debug((Object)("create() start : " + ejb.getCollectorID()));
        Connection conn = null;
        CollectorStatusPK pk = new CollectorStatusPK();
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO CC_COLLECTOR_STATUS (COLLECTORID, RUN_STATUS,ERROR_STATUS,END_STATUS,COUNT,LAST_COLLECT_DATE)values (?,?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, ejb.getCollectorID());
                stmt.setShort(2, (short)ejb.getRunStatus());
                stmt.setShort(3, (short)ejb.getErrorStatus());
                stmt.setShort(4, (short)ejb.getEndStatus());
                stmt.setLong(5, ejb.getCount());
                stmt.setTimestamp(6, null);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                    throw new EJBException(msg);
                }
                pk = new CollectorStatusPK(ejb.getCollectorID());
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("23505")) {
                    m_log.error((Object)("create() error : " + ejb.getCollectorID() + "DuplicateKeyException "));
                    throw new DuplicateKeyException(e.getMessage());
                }
                m_log.error((Object)("create() error :" + ejb.toString() + " EJBException "));
                throw new CreateException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getCollectorID()));
        return pk;
    }

    public CollectorStatusPK findByPrimaryKey(CollectorStatusPK pk) throws FinderException, EJBException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findbyPK() start : " + pk.getCollectorID()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM CC_COLLECTOR_STATUS WHERE COLLECTORID = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.collectorID);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            CollectorStatusPK collectorStatusPK = pk;
            Object var8_9 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            return collectorStatusPK;
        }
        try {
            try {
                String msg = "id " + pk.getCollectorID() + " not found.";
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            throw throwable;
        }
    }
}

