/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable;

import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.DataTableHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableCollection {
    private static Log m_log = LogFactory.getLog(DataTableCollection.class);
    private Object modifyLock = new Object();
    private final int m_pageSize;
    private long m_keepAlive = 60000L;
    private ConcurrentHashMap<String, IntervalAndLastReference> m_collectorIntervalMap;
    private ConcurrentHashMap<Integer, DataTableHolder> m_tableHolderMap;

    public DataTableCollection(int pageSize, long keepAlive) {
        this.m_pageSize = pageSize;
        this.m_keepAlive = keepAlive;
        this.m_collectorIntervalMap = new ConcurrentHashMap();
        this.m_tableHolderMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creatDataTableHolder(String collectorName, int interval) {
        m_log.debug((Object)("Create DataTableHolder : " + collectorName + ", " + interval));
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_collectorIntervalMap.put(collectorName, new IntervalAndLastReference(interval));
            if (this.m_tableHolderMap.get(interval) == null) {
                DataTableHolder holder = new DataTableHolder(this.m_pageSize);
                this.m_tableHolderMap.put(interval, holder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollectorName(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            IntervalAndLastReference ial = this.m_collectorIntervalMap.get(collectorName);
            if (ial == null) {
                return;
            }
            int removeInterval = ial.getInterval();
            Iterator<IntervalAndLastReference> ials = this.m_collectorIntervalMap.values().iterator();
            boolean removeFlg = true;
            while (ials.hasNext()) {
                int interval = ials.next().getInterval();
                if (interval != removeInterval) continue;
                removeFlg = false;
            }
            this.m_collectorIntervalMap.remove(collectorName);
            if (removeFlg) {
                m_log.info((Object)("Remove DataTableHolder : " + removeInterval));
                this.m_tableHolderMap.remove(removeInterval);
            }
        }
    }

    public boolean containsCollectorName(String collectorName) {
        IntervalAndLastReference ial = this.m_collectorIntervalMap.get(collectorName);
        if (ial == null) {
            return false;
        }
        return this.m_tableHolderMap.containsKey(ial.getInterval());
    }

    public Set<Integer> getIntervals() {
        return this.m_tableHolderMap.keySet();
    }

    public int getInterval(String collectorName) {
        IntervalAndLastReference ial = this.m_collectorIntervalMap.get(collectorName);
        if (ial == null) {
            return -1;
        }
        return ial.getInterval();
    }

    public long getLastReference(String collectorName) {
        IntervalAndLastReference ial = this.m_collectorIntervalMap.get(collectorName);
        if (ial == null) {
            return -1L;
        }
        return ial.getLastReference();
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTableHolder getDataTableHolder(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            IntervalAndLastReference ial = this.m_collectorIntervalMap.get(collectorName);
            if (ial == null) {
                return null;
            }
            ial.setLastReference();
            return this.m_tableHolderMap.get(ial.getInterval());
        }
    }

    public Set<String> getCollectorNames() {
        return this.m_collectorIntervalMap.keySet();
    }

    public void insertDataTable(int interval, DataTable table, String checkKey) throws NotInitializedException {
        DataTableHolder holder = this.m_tableHolderMap.get(interval);
        if (holder == null) {
            throw new NotInitializedException("DataTableHolder is not found.");
        }
        holder.insertDataTable(table, checkKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAlive(long now) {
        Object object = this.modifyLock;
        synchronized (object) {
            m_log.debug((Object)("DataTableCollection check : " + now));
            ArrayList<String> removeList = new ArrayList<String>();
            Set collectorNames = this.m_collectorIntervalMap.keySet();
            for (String collcetorName : collectorNames) {
                int interval = this.m_collectorIntervalMap.get(collcetorName).getInterval();
                long lastRef = this.m_collectorIntervalMap.get(collcetorName).getLastReference();
                if (now < lastRef + (long)interval * 1000L * 2L + this.m_keepAlive) continue;
                removeList.add(collcetorName);
            }
            if (removeList.size() > 0) {
                for (String collcetorName : removeList) {
                    m_log.debug((Object)("remove CollectorName : " + collcetorName + ", " + this.m_collectorIntervalMap.get(collcetorName).getInterval()));
                    this.m_collectorIntervalMap.remove(collcetorName);
                }
                HashSet<Integer> activeIntrevalSet = new HashSet<Integer>();
                collectorNames = this.m_collectorIntervalMap.keySet();
                for (String collcetorName : collectorNames) {
                    int interval = this.m_collectorIntervalMap.get(collcetorName).getInterval();
                    activeIntrevalSet.add(interval);
                }
                HashSet removeIntrevalSet = new HashSet(this.m_tableHolderMap.keySet());
                removeIntrevalSet.removeAll(activeIntrevalSet);
                Iterator intItr = removeIntrevalSet.iterator();
                while (intItr.hasNext()) {
                    int interval = (Integer)intItr.next();
                    m_log.debug((Object)("remove Interval : " + interval));
                    this.m_tableHolderMap.remove(interval);
                }
            }
            return this.m_tableHolderMap.size() == 0;
        }
    }

    private class IntervalAndLastReference {
        private final int m_interval;
        private long m_lastReference;

        public IntervalAndLastReference(int interval) {
            this.m_interval = interval;
            this.m_lastReference = System.currentTimeMillis();
        }

        public int getInterval() {
            return this.m_interval;
        }

        public long getLastReference() {
            return this.m_lastReference;
        }

        public void setLastReference() {
            this.m_lastReference = System.currentTimeMillis();
        }
    }
}

