/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable;

import com.clustercontrol.sharedtable.TableEntry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
implements Cloneable {
    private final long createTime = System.currentTimeMillis();
    private final ConcurrentHashMap<String, TableEntry> m_hm = new ConcurrentHashMap();
    private volatile long lastModify;

    public void putValue(String key, long date, Object value) {
        this.m_hm.put(key, new TableEntry(key, date, value));
        this.lastModify = System.currentTimeMillis();
    }

    public void putValue(TableEntry entry) {
        this.m_hm.put(entry.getKey(), entry);
        this.lastModify = System.currentTimeMillis();
    }

    public TableEntry getValue(String key) {
        TableEntry entry = this.m_hm.get(key);
        return entry;
    }

    public Set<TableEntry> getValueSetStartWith(String prefix) {
        if (this.m_hm.size() == 0) {
            return null;
        }
        HashSet<TableEntry> set = new HashSet<TableEntry>();
        for (Map.Entry<String, TableEntry> entry : this.m_hm.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    public TableEntry removeValue(String key) {
        TableEntry entry = this.m_hm.remove(key);
        this.lastModify = System.currentTimeMillis();
        return entry;
    }

    public Set<String> keySet() {
        return this.m_hm.keySet();
    }

    public void clear() {
        this.m_hm.clear();
        this.lastModify = System.currentTimeMillis();
    }

    public long getLastModify() {
        return this.lastModify;
    }

    public long getCreateTime() {
        return this.createTime;
    }
}

