/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesConfigDelegate;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLTFileDelegate
implements ServicesConfigDelegate {
    private static Logger log = Logger.getLogger(XSLTFileDelegate.class);

    public void applyConfig(ServiceConfig config, MBeanServer server) throws Exception {
        Element delegateConfig = (Element)config.getServiceConfigDelegateConfig();
        if (delegateConfig == null) {
            throw new IllegalArgumentException("ServiceConfig.ServiceConfigDelegateConfig is null");
        }
        Element xslConfigElement = (Element)delegateConfig.getElementsByTagName("xslt-config").item(0);
        if (xslConfigElement == null) {
            throw new IllegalArgumentException("No valid xslt config found");
        }
        String configName = xslConfigElement.getAttribute("configName");
        log.debug((Object)("configName = " + configName));
        if (configName.length() == 0) {
            throw new IllegalArgumentException("No valid configName attribute found");
        }
        ObjectName serviceName = new ObjectName(config.getServiceName());
        log.debug((Object)("serviceName = " + serviceName));
        String oldValue = (String)server.getAttribute(serviceName, configName);
        log.debug((Object)("oldValue = " + oldValue));
        String tmpName = System.getProperty("jboss.server.temp.dir");
        File tempDirectory = new File(tmpName);
        File targetFile = File.createTempFile("server", ".xml", tempDirectory);
        targetFile.deleteOnExit();
        log.debug((Object)("targetFile: " + targetFile.getCanonicalPath()));
        ServiceBinding[] bindings = config.getBindings();
        if (bindings == null || bindings.length == 0) {
            throw new IllegalArgumentException("No port binding specified");
        }
        int port = bindings[0].getPort();
        String host = bindings[0].getHostName();
        try {
            String xslText = xslConfigElement.getFirstChild().getNodeValue();
            log.trace((Object)("XSL text:" + xslText));
            StreamSource xslSource = new StreamSource(new StringReader(xslText));
            StreamSource xmlSource = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(oldValue));
            StreamResult xmlResult = new StreamResult(new FileOutputStream(targetFile));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslSource);
            transformer.setParameter("port", new Integer(port));
            log.debug((Object)("set port parameter to:" + port));
            if (host != null) {
                transformer.setParameter("host", host);
                log.debug((Object)("set host parameter to:" + host));
            }
            NodeList attributes = delegateConfig.getElementsByTagName("xslt-param");
            for (int a = 0; a < attributes.getLength(); ++a) {
                Element attr = (Element)attributes.item(a);
                String name = attr.getAttribute("name");
                if (name.length() == 0) {
                    throw new IllegalArgumentException("attribute element #" + a + " has no name attribute");
                }
                String attrExp = MetaData.getElementContent((Element)attr);
                String attrValue = StringPropertyReplacer.replaceProperties((String)attrExp);
                transformer.setParameter(name, attrValue);
                log.debug((Object)("set " + name + " parameter to:" + attrValue));
            }
            transformer.transform(xmlSource, xmlResult);
            Attribute mbeanConfigAttr = new Attribute(configName, targetFile.getCanonicalPath());
            server.setAttribute(serviceName, mbeanConfigAttr);
        }
        catch (Exception ex) {
            log.error((Object)"Error while transforming xml", (Throwable)ex);
        }
    }
}

