/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoUtil;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.notify.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.notify.util.InhibitAction;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputStatus
extends InhibitAction {
    protected static Log m_log = LogFactory.getLog(OutputStatus.class);

    public synchronized void outputStatus(OutputNotifyGroupInfo outputInfo) throws FinderException, NamingException {
        NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
        NotifyStatusInfoLocal statusInfo = NotifyStatusInfoUtil.getLocalHome().findByPrimaryKey(new NotifyStatusInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
        if (statusInfo == null) {
            m_log.debug((Object)"onMessage() : \u51fa\u529b\u3059\u308b\u91cd\u8981\u5ea6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (statusInfo.getStatusFlg() == 1) {
            boolean isRun = false;
            if (statusInfo.getStatusInhibitionFlg() == 1 && notifyInfo.getInhibitionFlg() != 0) {
                try {
                    boolean isInhibit = super.isInhibit(outputInfo, notifyInfo);
                    if (!isInhibit) {
                        isRun = true;
                    }
                }
                catch (NumberFormatException e) {
                    m_log.error((Object)("outputStatus() : " + e.getMessage()), (Throwable)e);
                }
                catch (RemoteException e) {
                    m_log.error((Object)("outputStatus() : " + e.getMessage()), (Throwable)e);
                }
                catch (CreateException e) {
                    m_log.error((Object)("outputStatus() : " + e.getMessage()), (Throwable)e);
                }
            } else {
                isRun = true;
            }
            if (isRun) {
                this.outputStatusInfo(outputInfo, statusInfo);
            }
        }
    }

    public boolean outputStatusInfo(OutputNotifyGroupInfo output, NotifyStatusInfoLocal statusInfo) {
        boolean result = false;
        if (statusInfo.getStatusFlg() == 1) {
            StatusInfoLocal outputStatus = null;
            boolean insertFlg = false;
            try {
                StatusInfoPK pk = new StatusInfoPK(output.getMonitorId(), output.getPluginId(), output.getFacilityId());
                outputStatus = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
            }
            catch (NamingException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (FinderException e) {
                insertFlg = true;
            }
            try {
                if (insertFlg) {
                    this.insertStatusInfo(output, statusInfo);
                    result = true;
                } else {
                    this.updateStatusInfo(outputStatus, output, statusInfo);
                    result = true;
                }
            }
            catch (NamingException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (CreateException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (EJBException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
        }
        return result;
    }

    public void insertStatusInfo(OutputNotifyGroupInfo outputInfo, NotifyStatusInfoLocal statusInfo) throws NamingException, CreateException {
        try {
            Integer expirationFlg = this.getExpirationFlg(statusInfo);
            Timestamp expirationDate = null;
            if (expirationFlg != null) {
                expirationDate = this.getExpirationDate(outputInfo, statusInfo);
            }
            StatusInfoUtil.getLocalHome().create(outputInfo.getFacilityId(), outputInfo.getMonitorId(), outputInfo.getPluginId(), outputInfo.getApplication(), outputInfo.getMessageId(), outputInfo.getMessage(), new Integer(outputInfo.getPriority()), new Timestamp(outputInfo.getGenerationDate().getTime()), outputInfo.getOutputDate(), expirationFlg, expirationDate);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public void updateStatusInfo(StatusInfoLocal outputStatus, OutputNotifyGroupInfo output, NotifyStatusInfoLocal statusInfo) throws EJBException {
        if (statusInfo != null) {
            Integer expirationFlg = this.getExpirationFlg(statusInfo);
            Timestamp expirationDate = null;
            if (expirationFlg != null) {
                expirationDate = this.getExpirationDate(output, statusInfo);
            }
            outputStatus.setApplication(output.getApplication());
            outputStatus.setMessageId(output.getMessageId());
            outputStatus.setMessage(output.getMessage());
            if (outputStatus.getPriority().intValue() != output.getPriority()) {
                outputStatus.setGenerationDate(new Timestamp(output.getGenerationDate().getTime()));
            }
            outputStatus.setPriority(new Integer(output.getPriority()));
            outputStatus.setOutputDate(output.getOutputDate());
            outputStatus.setExpirationFlg(expirationFlg);
            outputStatus.setExpirationDate(expirationDate);
        }
    }

    private Integer getExpirationFlg(NotifyStatusInfoLocal statusInfo) {
        Integer expirationFlg = null;
        if (statusInfo != null) {
            if (11 == statusInfo.getStatusInvalidFlg()) {
                expirationFlg = new Integer(statusInfo.getStatusInvalidFlg());
            }
            if (12 == statusInfo.getStatusInvalidFlg()) {
                expirationFlg = new Integer(statusInfo.getStatusUpdatePriority());
            }
        }
        return expirationFlg;
    }

    private Timestamp getExpirationDate(OutputNotifyGroupInfo outputInfo, NotifyStatusInfoLocal statusInfo) {
        Timestamp expirationDate = null;
        if (outputInfo != null && statusInfo != null && statusInfo.getStatusValidPeriod() > 0) {
            Calendar cal = null;
            cal = Calendar.getInstance();
            cal.setTime(outputInfo.getOutputDate());
            cal.add(12, statusInfo.getStatusValidPeriod());
            expirationDate = new Timestamp(cal.getTimeInMillis());
        }
        return expirationDate;
    }
}

