/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        String prop = sm != null ? SystemPropertyAction.PRIVILEGED.getProperty(name, defaultValue) : SystemPropertyAction.NON_PRIVILEGED.getProperty(name, defaultValue);
        return prop;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    public static String execCmd(String cmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        String line = sm != null ? RuntimeActions.PRIVILEGED.execCmd(cmd) : RuntimeActions.NON_PRIVILEGED.execCmd(cmd);
        return line;
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    static interface RuntimeActions {
        public static final RuntimeActions PRIVILEGED = new RuntimeActions(){

            public String execCmd(final String cmd) throws Exception {
                try {
                    String line = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return NON_PRIVILEGED.execCmd(cmd);
                        }
                    });
                    return line;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions NON_PRIVILEGED = new RuntimeActions(){

            public String execCmd(String cmd) throws Exception {
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(cmd);
                InputStream stdin = p.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
                String line = reader.readLine();
                stdin.close();
                int exitCode = p.waitFor();
                log.debug("Command exited with: " + exitCode);
                return line;
            }
        };

        public String execCmd(String var1) throws Exception;
    }

    static interface SystemPropertyAction {
        public static final SystemPropertyAction PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(final String name, final String defaultValue) {
                String prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String p = System.getProperty(name, defaultValue);
                        return p;
                    }
                });
                return prop;
            }
        };
        public static final SystemPropertyAction NON_PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(String name, String defaultValue) {
                String prop = System.getProperty(name, defaultValue);
                return prop;
            }
        };

        public String getProperty(String var1, String var2);
    }
}

