/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class MarshalledValueInputStream
extends ObjectInputStream {
    public MarshalledValueInputStream(InputStream is) throws IOException {
        super(is);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String className = v.getName();
        return loader.loadClass(className);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] ifaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            ifaceClasses[i] = loader.loadClass(interfaces[i]);
        }
        return Proxy.getProxyClass(loader, ifaceClasses);
    }
}

