/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.Agent;
import com.clustercontrol.agent.ReceiveTopic;
import com.clustercontrol.agent.util.InternalLogger;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue
implements ExceptionListener {
    private static final String QUEUE_CON_FACTORY = "ConnectionFactory";
    private static final String QUEUE_USER_NAME = "queue.user.name";
    private static final String QUEUE_USER_PASSWORD = "queue.user.password";
    private static final long SEND_TIMEOUT = 60000L;
    private static final long RECONNECT_TIMEOUT = 60000L;
    private Agent m_agent;
    private Properties m_props;
    private QueueConnection m_con;
    private Queue m_queue;
    private QueueSession m_session = null;
    private QueueConnectionFactory m_factory;
    private volatile boolean m_isErr = false;
    private long m_interval = 10000L;
    private static Log log = LogFactory.getLog(SendQueue.class);
    private final Object reInitialLock = new Object();
    private final Object sendQueueLock = new Object();
    private volatile Object connectionLock = new Object();
    private volatile boolean internalErroInhibitflag = false;

    public SendQueue(Agent agent, Properties props) {
        this.m_agent = agent;
        this.m_props = props;
        String interval = this.m_props.getProperty("sendqueue.reconnection.interval");
        if (interval != null) {
            try {
                this.m_interval = Integer.parseInt(interval) * 1000;
            }
            catch (NumberFormatException e) {
                log.error((Object)"sendqueue.reconnection.interval", (Throwable)e);
            }
        }
        this.initial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reInitial() {
        this.m_isErr = true;
        Object object = this.reInitialLock;
        synchronized (object) {
            boolean bl;
            if (!this.m_isErr) {
                return true;
            }
            log.debug((Object)"reInitial() start");
            ExecutorService es = null;
            Future<Boolean> task = null;
            try {
                ReconnectorThreadFactory threadFactory = new ReconnectorThreadFactory(Thread.currentThread().getName());
                es = Executors.newSingleThreadExecutor(threadFactory);
                task = es.submit(new Reconnector());
                bl = task.get(60000L, TimeUnit.MILLISECONDS);
                task.cancel(true);
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    this.m_isErr = true;
                    bl2 = false;
                    task.cancel(true);
                }
                catch (Throwable throwable) {
                    task.cancel(true);
                    if (es != null) {
                        es.shutdown();
                    }
                    log.debug((Object)"reInitial() end");
                    throw throwable;
                }
                if (es != null) {
                    es.shutdown();
                }
                log.debug((Object)"reInitial() end");
                return bl2;
            }
            if (es != null) {
                es.shutdown();
            }
            log.debug((Object)"reInitial() end");
            return bl;
        }
    }

    public void terminate() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(RunResultInfo info) {
        Object object = this.sendQueueLock;
        synchronized (object) {
            log.debug((Object)("put() start  : " + info.getCommandType() + ", " + info.getSessionId() + ", " + info.getJobId()));
            while (!ReceiveTopic.isHistoryClear()) {
                ExecutorService es = null;
                Future<Boolean> task = null;
                try {
                    SenderThreadFactory threadFactory = new SenderThreadFactory(info.getSessionId());
                    es = Executors.newSingleThreadExecutor(threadFactory);
                    log.debug((Object)("put() submit : " + info.getCommandType() + ", " + info.getSessionId() + ", " + info.getJobId()));
                    task = es.submit(new Sender(info));
                    boolean sendQueueStatus = task.get(60000L, TimeUnit.MILLISECONDS);
                    if (!sendQueueStatus) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    if (this.internalErroInhibitflag) {
                        log.error((Object)"Failed to connect to MGR");
                    } else {
                        log.error((Object)"Failed to connect to MGR", (Throwable)e);
                    }
                    if (!this.internalErroInhibitflag) {
                        InternalLogger.error("hinemos_jobagent: Failed to connect to MGR");
                        this.internalErroInhibitflag = true;
                    }
                    try {
                        Thread.sleep(this.m_interval);
                    }
                    catch (InterruptedException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    this.m_isErr = true;
                    this.reInitial();
                    log.info((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30ea\u30c8\u30e9\u30a4");
                }
                finally {
                    task.cancel(true);
                    if (es != null) {
                        es.shutdown();
                    }
                    log.debug((Object)("put() end    : " + info.getCommandType() + ", " + info.getSessionId() + ", " + info.getJobId()));
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (QueueConnectionFactory)con.lookup(QUEUE_CON_FACTORY);
            this.m_con = this.m_props.getProperty(QUEUE_USER_NAME) != null ? this.m_factory.createQueueConnection(this.m_props.getProperty(QUEUE_USER_NAME), this.m_props.getProperty(QUEUE_USER_PASSWORD)) : this.m_factory.createQueueConnection();
            this.m_session = this.m_con.createQueueSession(false, 1);
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.m_queue = (Queue)con.lookup("queue/clustercontrolJobManagementStatus");
            this.connectionLock = new Object();
            this.m_isErr = false;
            this.internalErroInhibitflag = false;
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.m_isErr = true;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0.getMessage(), (Throwable)arg0);
        this.m_agent.reConnection();
    }

    public void reconnect() {
        this.m_isErr = true;
    }

    private class ReconnectorThreadFactory
    implements ThreadFactory {
        private final String m_threadName;

        public ReconnectorThreadFactory(String threadName) {
            this.m_threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "Reconnector-" + this.m_threadName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reconnector
    implements Callable<Boolean> {
        private Reconnector() {
        }

        @Override
        public Boolean call() throws Exception {
            boolean ret = false;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
            SendQueue.this.terminate();
            if (SendQueue.this.initial()) {
                ret = true;
                log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
                SendQueue.this.m_isErr = false;
            } else {
                log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
            }
            return ret;
        }
    }

    private class SenderThreadFactory
    implements ThreadFactory {
        private final String m_threadName;

        public SenderThreadFactory(String threadName) {
            this.m_threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "Sender-" + this.m_threadName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sender
    implements Callable<Boolean> {
        private RunResultInfo m_info;

        public Sender(RunResultInfo info) {
            this.m_info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            if (SendQueue.this.m_isErr && !SendQueue.this.reInitial()) {
                return false;
            }
            if (SendQueue.this.m_session == null) {
                return false;
            }
            QueueSender sender = null;
            try {
                Object object = SendQueue.this.connectionLock;
                synchronized (object) {
                    sender = SendQueue.this.m_session.createSender(SendQueue.this.m_queue);
                    ObjectMessage mess = SendQueue.this.m_session.createObjectMessage((Serializable)this.m_info);
                    log.info((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1 : SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId() + ", CommandType=" + this.m_info.getCommandType()));
                    sender.send((Message)mess);
                }
                object = true;
                return object;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (sender != null) {
                        sender.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

