package org.postgresforest.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class ForestLogFormatter extends Formatter {
    
    @Override
    public String format(final LogRecord record) {
        final StringBuilder message = new StringBuilder(128);
        
        // 時刻
        message.append(String.format("%tD %<tT.%<tL", record.getMillis()));
        message.append(' ');
        // スレッドID
        // message.append(record.getThreadID());
        // message.append(' ');
        message.append(record.getLevel().toString());
        message.append(' ');
        // クラス名
        final String className = record.getSourceClassName();
        message.append(className != null ? className : "N/A");
        message.append(' ');
        // メソッド名
        final String methodName = record.getSourceMethodName();
        message.append("[");
        message.append(methodName != null ? methodName : "N/A");
        message.append("] ");
        // メッセージ
        message.append(formatMessage(record));
        message.append('\n');
        // エラー（あれば）
        // TODO Forestの特殊Exceptionで、これがprintStackTraceの形と同じになるか検証する必要あり
        final Throwable throwable = record.getThrown();
        if (throwable != null) {
            message.append(throwable.toString());
            message.append('\n');
            for (final StackTraceElement elem : throwable.getStackTrace()) {
                message.append('\t');
                message.append(elem.toString());
                message.append('\n');
            }
        }
        return message.toString();
    }
    
}
