/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public class MySQLValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -2227528634302168878L;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jdbc$vendor$MySQLValidConnectionChecker == null ? (class$org$jboss$resource$adapter$jdbc$vendor$MySQLValidConnectionChecker = MySQLValidConnectionChecker.class$("org.jboss.resource.adapter.jdbc.vendor.MySQLValidConnectionChecker")) : class$org$jboss$resource$adapter$jdbc$vendor$MySQLValidConnectionChecker));
    private Method ping;
    private boolean driverHasPingMethod = false;
    private static Object[] params = new Object[0];
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$vendor$MySQLValidConnectionChecker;

    public MySQLValidConnectionChecker() {
        try {
            Class<?> mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Connection");
            this.ping = mysqlConnection.getMethod("ping", new Class[0]);
            if (this.ping != null) {
                this.driverHasPingMethod = true;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Cannot resolve com.mysq.jdbc.Connection.ping method.  Will use 'SELECT 1' instead.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SQLException isValidConnection(Connection c) {
        block19: {
            if (this.driverHasPingMethod) {
                try {
                    this.ping.invoke((Object)c, params);
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        return (SQLException)e;
                    }
                    log.warn((Object)"Unexpected error in ping", (Throwable)e);
                    return new SQLException("ping failed: " + e.toString());
                }
            }
            Statement stmt = null;
            stmt = c.createStatement();
            stmt.executeQuery("SELECT 1");
            Object var6_4 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block19;
            }
            catch (SQLException e2) {}
            break block19;
            {
                catch (Exception e) {
                    SQLException sQLException;
                    if (e instanceof SQLException) {
                        SQLException sQLException2 = (SQLException)e;
                        Object var6_5 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                        return sQLException2;
                    }
                    try {
                        log.warn((Object)"Unexpected error in ping (SELECT 1)", (Throwable)e);
                        sQLException = new SQLException("ping (SELECT 1) failed: " + e.toString());
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    return sQLException;
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

