/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.jdbc;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.postgresforest.Driver;
import org.postgresforest.core.Field;
import org.postgresforest.core.ParameterList;
import org.postgresforest.core.Query;
import org.postgresforest.core.ResultCursor;
import org.postgresforest.jdbc3.AbstractJdbc3Statement;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.ColumnInfo;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.NullKey;
import org.postgresforest.vm.OrderInfo;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.SelectColumnInfo;
import org.postgresforest.vm.core.QueryExecutorImpl;
import org.postgresforest.vm.core.SimpleQuery;
import org.postgresforest.vm.err.ForestSQLState;
import org.postgresforest.vm.gsc.GscData;
import org.postgresforest.vm.jdbc.ForestConnection;
import org.postgresforest.vm.jdbc.ForestResultSet;

public class ForestStatement
extends AbstractJdbc3Statement
implements Statement {
    protected LogUtil m_logUtil;
    protected QueryExecutorImpl m_queryExecutor;
    protected GscData m_gsc;

    public ForestStatement(ForestConnection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability);
        this.m_queryExecutor = (QueryExecutorImpl)this.connection.getQueryExecutor();
        this.m_logUtil = this.m_queryExecutor.getLogUtil();
        this.m_gsc = this.m_queryExecutor.getGsc();
    }

    public ForestStatement(ForestConnection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, isCallable, rsType, rsConcurrency, rsHoldability);
        SQLException ex = ((SimpleQuery)this.preparedQuery).getParserErr();
        if (ex != null) {
            throw ex;
        }
        this.m_queryExecutor = (QueryExecutorImpl)connection.getQueryExecutor();
        this.m_logUtil = this.m_queryExecutor.getLogUtil();
        this.m_gsc = this.m_queryExecutor.getGsc();
    }

    public ResultSet createResultSet(Query originalQuery, Field[] fields, Vector tuples, ResultCursor cursor) throws SQLException {
        ForestResultSet newResult = new ForestResultSet(originalQuery, this, fields, tuples, cursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        newResult.setFetchSize(this.getFetchSize());
        newResult.setFetchDirection(this.getFetchDirection());
        return newResult;
    }

    protected void execute(Query queryToExecute, ParameterList queryParameters, int flags) throws SQLException {
        this.chkRollBack();
        if (this.connection.getAutoCommit() && !this.m_gsc.isTableAvailable()) {
            this.m_gsc.waitTableAvailable();
        }
        SimpleQuery simpleQuery = (SimpleQuery)queryToExecute;
        simpleQuery.setTimeout(this.timeout);
        try {
            super.execute(queryToExecute, queryParameters, flags);
        }
        catch (SQLException e1) {
            throw e1;
        }
        finally {
            this.chkRollBack();
        }
        Parser parser = simpleQuery.getParser();
        ForestResultSet rs = (ForestResultSet)this.result.getResultSet();
        if (simpleQuery.getQueryType() == 0 && simpleQuery.getQueryNum() > 1) {
            try {
                this.m_queryExecutor.addMetaDataAccess();
                if (parser.hasGroupBy() || parser.hasExecFunction()) {
                    ArrayList<Object> grpRowList = new ArrayList<Object>();
                    Vector rows = rs.getRows();
                    if (parser.hasGroupBy()) {
                        ArrayList groupList = parser.getGroupList();
                        TreeMap sortMap = this.sortRows(rs, groupList);
                        this.getGroupRows(sortMap, groupList, 0, grpRowList);
                    } else {
                        grpRowList.add(rows.clone());
                    }
                    rows.clear();
                    ArrayList selectList = parser.getSelectList();
                    for (int i = 0; i < grpRowList.size(); ++i) {
                        Vector groupRows = new Vector((Collection)grpRowList.get(i));
                        ForestResultSet tmpRes = rs.Copy();
                        tmpRes.setRows(groupRows);
                        rows.add(groupRows.get(0));
                        rs._last();
                        tmpRes.next();
                        while (tmpRes.next()) {
                            for (int j = 0; j < selectList.size(); ++j) {
                                SelectColumnInfo selectColumnInfo = (SelectColumnInfo)selectList.get(j);
                                int columnIndex = selectColumnInfo.getNumber();
                                Comparable tmpValue = null;
                                Comparable srcValue = null;
                                Comparable<Long> distValue = null;
                                switch (selectColumnInfo.getFunctionType()) {
                                    case 2: {
                                        long tmpLongValue = tmpRes.getLong(columnIndex);
                                        long srcLongValue = rs.getLong(columnIndex);
                                        distValue = new Long(tmpLongValue + srcLongValue);
                                        break;
                                    }
                                    case 0: {
                                        tmpValue = (Comparable)tmpRes.getObject(columnIndex);
                                        srcValue = (Comparable)rs.getObject(columnIndex);
                                        if (tmpValue != null && srcValue != null) {
                                            if (tmpValue.compareTo(srcValue) > 0) {
                                                distValue = tmpValue;
                                                break;
                                            }
                                            distValue = srcValue;
                                            break;
                                        }
                                        if (tmpValue != null) {
                                            distValue = tmpValue;
                                            break;
                                        }
                                        if (srcValue == null) break;
                                        distValue = srcValue;
                                        break;
                                    }
                                    case 1: {
                                        tmpValue = (Comparable)tmpRes.getObject(columnIndex);
                                        srcValue = (Comparable)rs.getObject(columnIndex);
                                        if (tmpValue != null && srcValue != null) {
                                            if (tmpValue.compareTo(srcValue) < 0) {
                                                distValue = tmpValue;
                                                break;
                                            }
                                            distValue = srcValue;
                                            break;
                                        }
                                        if (tmpValue != null) {
                                            distValue = tmpValue;
                                            break;
                                        }
                                        if (srcValue == null) break;
                                        distValue = srcValue;
                                        break;
                                    }
                                    case 3: {
                                        long srcLongValue;
                                        long tmpLongValue;
                                        ResultSetMetaData rmeta = rs.getMetaData();
                                        switch (rmeta.getColumnType(columnIndex)) {
                                            case -5: 
                                            case 4: 
                                            case 5: {
                                                tmpLongValue = tmpRes.getLong(columnIndex);
                                                srcLongValue = rs.getLong(columnIndex);
                                                distValue = new Long(tmpLongValue + srcLongValue);
                                                break;
                                            }
                                            case 2: {
                                                BigDecimal tmpBigDecimal = (BigDecimal)tmpRes.getObject(columnIndex);
                                                BigDecimal srcBigDecimal = (BigDecimal)rs.getObject(columnIndex);
                                                distValue = srcBigDecimal.add(tmpBigDecimal);
                                                break;
                                            }
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                double tmpDoubleValue = tmpRes.getDouble(columnIndex);
                                                double srcDoubleValue = rs.getDouble(columnIndex);
                                                distValue = new Double(tmpDoubleValue + srcDoubleValue);
                                            }
                                        }
                                        break;
                                    }
                                }
                                if (distValue == null) continue;
                                rs.setObject(columnIndex, distValue);
                            }
                        }
                    }
                    rs._beforeFirst();
                }
                if (parser.hasOrderBy()) {
                    ArrayList orderList = parser.getOrderList();
                    TreeMap sortMap = this.sortRows(rs, orderList);
                    Vector sortRows = new Vector(this.getSortRows(sortMap, orderList, 0));
                    rs.setRows(sortRows);
                    rs._beforeFirst();
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("excute internal error.\n{0}", e), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
            }
            finally {
                this.m_queryExecutor.removeMetaDataAccess();
            }
            if (parser.hasLimit()) {
                Vector rows = rs.getRows();
                int rowCount = parser.getLimitCount();
                if (rows.size() < rowCount) {
                    rowCount = rows.size();
                }
                rows = new Vector(rows.subList(0, rowCount));
                rs.setRows(rows);
            }
        }
    }

    private TreeMap sortRows(ForestResultSet rs, ArrayList orderList) throws SQLException {
        TreeMap sortMap = new TreeMap();
        Vector rows = rs.getRows();
        while (rs.next()) {
            if (Driver.logDebug) {
                this.m_logUtil.debug("Row:" + rs.getRow());
            }
            this.sortRows(rs, sortMap, orderList, 0, rows);
        }
        return sortMap;
    }

    protected void sortRows(ResultSet rs, TreeMap sortMap, ArrayList grpList, int index, Vector rows) throws SQLException {
        ColumnInfo columnInfo = (ColumnInfo)grpList.get(index);
        Object objKey = rs.getObject(columnInfo.getNumber());
        if (objKey == null || !(objKey instanceof Comparable)) {
            objKey = new NullKey();
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug("TREE:[" + index + "]" + objKey.toString());
        }
        if (grpList.size() == index + 1) {
            Object value = rows.get(rs.getRow() - 1);
            if (sortMap.containsKey(objKey)) {
                ArrayList values = (ArrayList)sortMap.get(objKey);
                values.add(value);
            } else {
                ArrayList values = new ArrayList();
                values.add(value);
                sortMap.put(objKey, values);
            }
        } else {
            TreeMap subTreeMap = null;
            if (sortMap.containsKey(objKey)) {
                subTreeMap = (TreeMap)sortMap.get(objKey);
                this.sortRows(rs, subTreeMap, grpList, ++index, rows);
            } else {
                subTreeMap = new TreeMap();
                this.sortRows(rs, subTreeMap, grpList, index + 1, rows);
                sortMap.put(objKey, subTreeMap);
            }
        }
    }

    protected Collection getSortRows(TreeMap sortMap, ArrayList cols, int index) throws SQLException {
        OrderInfo orderInfo = (OrderInfo)cols.get(index);
        ArrayList sortRows = new ArrayList();
        ArrayList keys = new ArrayList(sortMap.keySet());
        if (orderInfo.getSort() == 1) {
            Collections.reverse(keys);
        }
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (Driver.logDebug) {
                this.m_logUtil.debug(key.toString());
            }
            if (cols.size() == index + 1) {
                sortRows.addAll((Collection)sortMap.get(key));
                continue;
            }
            TreeMap subSortMap = (TreeMap)sortMap.get(key);
            sortRows.addAll(this.getSortRows(subSortMap, cols, index + 1));
        }
        return sortRows;
    }

    protected void getGroupRows(Map sortMap, ArrayList cols, int index, Collection sortRows) throws SQLException {
        OrderInfo orderInfo = (OrderInfo)cols.get(index);
        ArrayList keys = new ArrayList(sortMap.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (Driver.logDebug) {
                this.m_logUtil.debug(key.toString());
            }
            if (cols.size() == index + 1) {
                sortRows.add((Collection)sortMap.get(key));
                continue;
            }
            Map subMap = (Map)sortMap.get(key);
            this.getGroupRows(subMap, cols, index + 1, sortRows);
        }
    }

    protected void chkRollBack() throws SQLException {
        if (this.m_queryExecutor.isRollback()) {
            this.m_queryExecutor.clearRollback();
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw this.m_queryExecutor.getRollbackException();
        }
    }
}

