/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.gsc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresforest.jdbc2.AbstractJdbc2Connection;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.Hash01;
import org.postgresforest.vm.HashLoader;
import org.postgresforest.vm.Hash_I;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.Logger;
import org.postgresforest.vm.ParamValue;
import org.postgresforest.vm.PartitionColumnInfo;
import org.postgresforest.vm.err.BrokenNotify_I;
import org.postgresforest.vm.err.DistError;
import org.postgresforest.vm.err.ForestSQLState;
import org.postgresforest.vm.err.NoBrokenNotifier;
import org.postgresforest.vm.gsc.ConfigInfo;
import org.postgresforest.vm.gsc.GscInfo;
import org.postgresforest.vm.gsc.ServerInfo;
import org.postgresforest.vm.gsc.TableInfo;
import org.postgresforest.vm.jdbc.ForestConnection;

public class GscData
extends Thread {
    protected ConfigInfo m_configInfo = null;
    protected ArrayList m_servers = null;
    protected HashMap m_tables = null;
    protected LogUtil m_logUtil;
    protected static String m_client;
    protected boolean m_tableAvailable = false;
    public static final int KEY_TYPE_NAME = 0;
    public static final int KEY_TYPE_NO = 1;
    protected static final DateFormat[] m_formatDate;
    protected static final DateFormat[] m_formatTime;
    protected static final DateFormat[] m_formatTimeStamp;
    protected String m_dbName = null;
    protected Properties m_prop = null;
    protected int m_DistSvrIdx = 0;
    protected boolean m_isClosed = false;
    protected boolean m_hasPartition = false;
    protected static BrokenNotify_I m_brokenNotifier;
    protected SQLException m_thredErr = null;
    protected ArrayList m_gscInfoList;
    private static final String PROTOCOL = "jdbc:postgresforest:";

    public GscData(String gsc, String config, String dbname, Properties info, LogUtil logUtil) throws SQLException {
        this.m_logUtil = logUtil;
        Logger.setLogUtil(this.m_logUtil);
        this.m_dbName = dbname;
        this.m_prop = info;
        this.m_configInfo = config == null ? new ConfigInfo("FOREST_DEFAULT_CONFIG") : new ConfigInfo(config);
        this.initialGscList(gsc);
        this.readData();
        if (this.m_configInfo.getReflesh() != 0) {
            this.setDaemon(true);
            this.start();
        }
    }

    protected void connectServers() {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            if (srvinf.getStatus() != 1 || srvinf.getConnection() != null) continue;
            String url = srvinf.getUrl() + this.m_dbName;
            try {
                Connection con = this.connect(url, this.m_prop);
                srvinf.setConnection(con);
                Logger.info("It connected with the DB server. (" + url + ")");
                continue;
            }
            catch (SQLException e2) {
                srvinf.setStatus(-1);
                this.updateDBstatus(srvinf, "CONNECT", e2);
                Logger.info("It was not connectable with the DB server. (" + url + ")");
            }
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return DriverManager.getConnection(PROTOCOL + url, info);
    }

    public synchronized void setServerBroken(Connection con, String query, Exception ex) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            if (!con.equals(srvinf.getConnection()) || srvinf.getStatus() == -1) continue;
            srvinf.setStatus(-1);
            this.updateDBstatus(srvinf, query, ex);
            Logger.info("Server status was set up into the obstacle. (" + srvinf.getUrl() + ")");
            con.close();
            srvinf.setConnection(null);
            break;
        }
    }

    public int getTimeout() {
        return this.m_configInfo.getTimeout();
    }

    public synchronized boolean isPartition(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.isPartition();
    }

    protected TableInfo getTableInfo(String tableName) throws PSQLException {
        String tblNameL = tableName.toLowerCase();
        TableInfo tblinfo = (TableInfo)this.m_tables.get(tblNameL);
        if (tblinfo == null) {
            throw new PSQLException(GT.tr("The table for {0} is not defined as GSC.", tableName), ForestSQLState.INTERNAL_ERROR);
        }
        return tblinfo;
    }

    public synchronized int getPartCount(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.getPartitionNum();
    }

    public synchronized ArrayList getPartCol(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        return collist;
    }

    public synchronized String[] getPartColNames(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        if (collist == null) {
            return new String[0];
        }
        String[] colNames = new String[collist.size()];
        for (int i = 0; i < colNames.length; ++i) {
            PartitionColumnInfo colinfo = (PartitionColumnInfo)collist.get(i);
            colNames[i] = colinfo.getName();
        }
        return colNames;
    }

    public synchronized int[] getPartColNums(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        int[] colNums = new int[collist.size()];
        for (int i = 0; i < colNums.length; ++i) {
            PartitionColumnInfo colinfo = (PartitionColumnInfo)collist.get(i);
            colNums[i] = colinfo.getNumber();
        }
        return colNums;
    }

    public synchronized Connection getDistServer(String[] table) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(table[0]);
        ArrayList svrlist = (ArrayList)tblinfo.getServers().clone();
        for (int i = 1; i < table.length; ++i) {
            TableInfo tblinfoWk = this.getTableInfo(table[i]);
            ArrayList svrlistWk = tblinfoWk.getServers();
            Iterator iter = svrlist.iterator();
            while (iter.hasNext()) {
                ServerInfo svrInfo = (ServerInfo)iter.next();
                if (svrlistWk.contains(svrInfo)) continue;
                iter.remove();
            }
        }
        int serverIdx = this.getSvrIdx();
        if (serverIdx < 0) {
            throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            if (svrInfo.getStatus() == 1 && svrlist.contains(svrInfo)) {
                return svrInfo.getConnection();
            }
            if (this.m_servers.size() > ++serverIdx) continue;
            serverIdx = 0;
        }
        throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized Connection getLastServer() throws SQLException {
        this.chkThredErr();
        ServerInfo svrInfo = (ServerInfo)this.m_servers.get(this.m_DistSvrIdx);
        if (svrInfo.getStatus() == 1) {
            return svrInfo.getConnection();
        }
        return this.getDistServer();
    }

    public synchronized Connection getDistServer() throws SQLException {
        this.chkThredErr();
        int serverIdx = this.getSvrIdx();
        if (serverIdx < 0) {
            throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
        }
        ServerInfo svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
        return svrInfo.getConnection();
    }

    public synchronized Connection getDistServer(String tableName, int PartNo) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList svrList = tblinfo.getServers(PartNo);
        for (int i = 0; i < svrList.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)svrList.get(i);
            if (srvinfo.getStatus() != 1) continue;
            return srvinfo.getConnection();
        }
        throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized ArrayList getDistServerList(String tableName, String[] tableList) throws SQLException {
        int i;
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList srvlist = tblinfo.getServers();
        ArrayList<ServerInfo> distSvrlist = new ArrayList<ServerInfo>();
        for (i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            distSvrlist.add(srvinfo);
        }
        for (i = 0; i < tableList.length; ++i) {
            TableInfo tblinfoWk = this.getTableInfo(tableList[i]);
            ArrayList srvlistWk = tblinfoWk.getServers();
            if (srvlistWk.containsAll(distSvrlist)) continue;
            throw new PSQLException(GT.tr("The server which cannot be processed exists."), ForestSQLState.INTERNAL_ERROR);
        }
        return this.getDistServerList(tableName);
    }

    public synchronized ArrayList getDistServerList(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList srvlist = tblinfo.getServers();
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public synchronized ArrayList getDistServerList(String tableName, int PartNo) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        if (tblinfo == null) {
            throw new PSQLException(GT.tr("The table for {0} is not defined as GSC.", tableName), ForestSQLState.INTERNAL_ERROR);
        }
        ArrayList srvlist = tblinfo.getServers(PartNo);
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public synchronized ArrayList getDistServerList() throws SQLException {
        this.chkThredErr();
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)this.m_servers.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException(GT.tr("There is no servers which can be processed."), ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public int getServerCount() {
        return this.m_servers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized int getPartNo(String table, HashMap valueMap, int type) throws SQLException {
        Hash_I hashobj;
        this.chkThredErr();
        TableInfo tblinf = this.getTableInfo(table);
        Hash_I hash_I = hashobj = tblinf.getHash();
        // MONITORENTER : hash_I
        ArrayList colList = tblinf.getColumnList();
        hashobj.clearCol();
        hashobj.setPartNum(this.getPartCount(table));
        int i = 0;
        while (true) {
            if (i >= colList.size()) {
                // MONITOREXIT : hash_I
                return hashobj.getNodeNo();
            }
            PartitionColumnInfo colinfo = (PartitionColumnInfo)colList.get(i);
            String value = null;
            if (type == 0) {
                ParamValue paramValue = (ParamValue)valueMap.get(colinfo.getName());
                value = paramValue.getValue();
            } else {
                Integer colNum = new Integer(colinfo.getNumber());
                ParamValue paramValue = (ParamValue)valueMap.get(colNum);
                value = paramValue.getValue();
            }
            if (value == null) {
                throw new PSQLException(GT.tr("NULL sets to a partition item."), ForestSQLState.INTERNAL_ERROR);
            }
            switch (colinfo.getType()) {
                case 4: 
                case 5: {
                    hashobj.addCol(new Double(value).intValue());
                    break;
                }
                case 1: 
                case 12: {
                    value = value.replaceAll("\\\\n", "\n");
                    value = value.replaceAll("\\\\t", "\t");
                    value = value.replaceAll("\\\\r", "\r");
                    value = value.replaceAll("''", "\\'");
                    hashobj.addCol(value);
                    break;
                }
                case 91: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Date.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatDate;
                        // MONITORENTER : m_formatDate
                        timelong = 0L;
                        for (j = 0; j < m_formatDate.length; ++j) {
                            try {
                                timelong = m_formatDate[j].parse(value).getTime();
                                hashobj.addCol(new Date(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException(GT.tr("The Type whose partition item is not corresponded."), ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                case 92: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Time.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatTime;
                        // MONITORENTER : m_formatTime
                        timelong = 0L;
                        for (j = 0; j < m_formatTime.length; ++j) {
                            try {
                                timelong = m_formatTime[j].parse(value).getTime();
                                hashobj.addCol(new Time(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException(GT.tr("The Type whose partition item is not corresponded."), ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                case 93: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Timestamp.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatTimeStamp;
                        // MONITORENTER : m_formatTimeStamp
                        timelong = 0L;
                        for (j = 0; j < m_formatTimeStamp.length; ++j) {
                            try {
                                timelong = m_formatTimeStamp[j].parse(value).getTime();
                                hashobj.addCol(new Time(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException(GT.tr("The Type whose partition item is not corresponded."), ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("The Type whose partition item is not corresponded."), ForestSQLState.INTERNAL_ERROR);
                }
            }
            ++i;
        }
    }

    public synchronized void close() {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            Connection con = srvinf.getConnection();
            if (!this.closeWithoutException(con)) continue;
            try {
                Logger.info("Connection with DB server was closed. (" + ((ForestConnection)con).getURL() + ")");
                continue;
            }
            catch (Exception e) {
                this.m_logUtil.debug(e.getMessage());
            }
        }
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.m_isClosed = true;
    }

    protected int getSvrIdx() {
        boolean retry = false;
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo svrInfo;
            if (this.m_configInfo.getDistCon() == 0 || retry) {
                ++this.m_DistSvrIdx;
                if (this.m_servers.size() <= this.m_DistSvrIdx) {
                    this.m_DistSvrIdx = 0;
                }
            }
            if ((svrInfo = (ServerInfo)this.m_servers.get(this.m_DistSvrIdx)).getStatus() == 1) {
                return this.m_DistSvrIdx;
            }
            retry = true;
        }
        return -1;
    }

    protected synchronized void setGscData(ArrayList servers, HashMap tables) {
        Logger.debug("GscData#setGscStatus()");
        if (this.m_servers == null) {
            this.m_servers = servers;
        } else {
            HashMap svrMap = this.getServerMap(this.m_servers);
            for (int i = 0; i < servers.size(); ++i) {
                ServerInfo newSvrInfo = (ServerInfo)servers.get(i);
                Integer dbNo = new Integer(newSvrInfo.getDbNo());
                ServerInfo oldSvrInfo = (ServerInfo)svrMap.get(dbNo);
                if (oldSvrInfo == null) continue;
                int oldStatus = oldSvrInfo.getStatus();
                int newStatus = newSvrInfo.getStatus();
                if (oldStatus == 1 && newStatus == -1) {
                    Connection con = oldSvrInfo.getConnection();
                    this.closeWithoutException(con);
                } else {
                    newSvrInfo.setConnection(oldSvrInfo.getConnection());
                }
                svrMap.remove(dbNo);
            }
            this.m_servers = servers;
            Iterator iter = svrMap.values().iterator();
            while (iter.hasNext()) {
                ServerInfo rmSvrInfo = (ServerInfo)iter.next();
                this.closeWithoutException(rmSvrInfo.getConnection());
            }
        }
        this.m_tables = tables;
        this.m_hasPartition = false;
        this.m_tableAvailable = true;
        Iterator iter = this.m_tables.values().iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            if (tableInfo.isPartition()) {
                this.m_hasPartition = true;
            }
            if (tableInfo.getStatus() != 1) continue;
            this.m_tableAvailable = false;
        }
        if (this.m_hasPartition) {
            Logger.info("DB Partition.");
        } else {
            Logger.info("DB NoPartition.");
        }
    }

    protected synchronized void setGscStatus(ArrayList servers) throws SQLException {
        Logger.debug("GscData#setGscStatus()");
        if (this.m_servers == null) {
            this.m_servers = servers;
        } else {
            int cntServers = this.m_servers.size();
            if (cntServers != servers.size()) {
                throw new PSQLException(GT.tr("Number of servers has been changed."), ForestSQLState.INTERNAL_ERROR);
            }
            for (int i = 0; i < cntServers; ++i) {
                int newStatus;
                ServerInfo newSvrInfo = (ServerInfo)servers.get(i);
                ServerInfo oldSvrInfo = (ServerInfo)this.m_servers.get(i);
                if (newSvrInfo.getId() == oldSvrInfo.getId()) {
                    int oldStatus = oldSvrInfo.getStatus();
                    newStatus = newSvrInfo.getStatus();
                    if (oldStatus == 1 && newStatus == -1) {
                        this.closeWithoutException(oldSvrInfo.getConnection());
                        oldSvrInfo.setConnection(null);
                        Iterator iter = this.m_gscInfoList.iterator();
                        while (iter.hasNext()) {
                            GscInfo gscInfo = (GscInfo)iter.next();
                            if (gscInfo.getId() == newSvrInfo.getId()) {
                                gscInfo.setStatus(-1);
                                break;
                            }
                            Logger.debug("GscData#setGscStatus(): " + gscInfo.toString());
                        }
                    }
                } else {
                    throw new PSQLException(GT.tr("An effective global system catalog does not exist."), ForestSQLState.INTERNAL_ERROR);
                }
                oldSvrInfo.setStatus(newStatus);
            }
        }
    }

    protected HashMap getServerMap(ArrayList serverList) {
        HashMap<Integer, ServerInfo> serverMap = new HashMap<Integer, ServerInfo>();
        for (int i = 0; i < serverList.size(); ++i) {
            ServerInfo srvInfo = (ServerInfo)serverList.get(i);
            Integer dbNo = new Integer(srvInfo.getDbNo());
            serverMap.put(dbNo, srvInfo);
        }
        return serverMap;
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public void setClosed(boolean closed) {
        this.m_isClosed = closed;
    }

    public int getRetry() {
        return this.m_configInfo.getRetry();
    }

    public boolean hasPartition() {
        return this.m_hasPartition;
    }

    public LogUtil getLogUtil() {
        return this.m_logUtil;
    }

    public boolean canPartitionMode() {
        return this.m_configInfo.canPartitionMode();
    }

    public boolean getUpdateSyncMode() {
        return this.m_configInfo.isUpdateSyncMode();
    }

    public void setUpdateSyncMode(boolean b) {
        this.m_configInfo.setUpdateSyncMode(b);
    }

    public synchronized boolean isPartition2(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.isPartition2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ResultSet executeQueryGSC(String sql) throws SQLException {
        ArrayList arrayList = this.m_gscInfoList;
        synchronized (arrayList) {
            Iterator iter = this.m_gscInfoList.iterator();
            while (iter.hasNext()) {
                ResultSet resultSet;
                GscInfo gscInfo = (GscInfo)iter.next();
                if (gscInfo.getStatus() == -1) continue;
                String serverURL = gscInfo.getUrl();
                Connection con = null;
                try {
                    con = this.connect(serverURL, this.m_prop);
                    Statement smt = con.createStatement();
                    resultSet = smt.executeQuery(sql);
                    this.closeWithoutException(con);
                }
                catch (SQLException e) {
                    try {
                        this.closeWithoutException(con);
                        continue;
                        catch (Throwable throwable) {
                            this.closeWithoutException(con);
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new PSQLException(GT.tr("An effective global system catalog does not exist."), ForestSQLState.INTERNAL_ERROR);
                    }
                }
                return resultSet;
            }
        }
    }

    protected void chkThredErr() throws SQLException {
        if (this.m_thredErr != null) {
            throw this.m_thredErr;
        }
    }

    public synchronized boolean isTableAvailable() {
        return this.m_tableAvailable;
    }

    public void waitTableAvailable() throws SQLException {
        while (!this.isTableAvailable()) {
            try {
                Logger.info("Sleeping 3 secs before retrying...");
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                throw new PSQLException(GT.tr("excute internal error.\n{0}", ex), ForestSQLState.INTERNAL_ERROR, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialGscList(String gscStr) throws SQLException {
        this.m_gscInfoList = new ArrayList();
        StringTokenizer t = new StringTokenizer(gscStr, ",");
        Logger.debug("GSC CONNECTION STRING: " + gscStr);
        while (t.hasMoreTokens()) {
            Connection con;
            block6: {
                con = null;
                String serverURL = t.nextToken();
                Logger.debug("GSC SERVER URL: " + serverURL);
                try {
                    con = this.connect(serverURL, this.m_prop);
                    if (!this.buildGscInfoList(con, serverURL)) break block6;
                    ConfigInfo configInfo = this.readConfig(con);
                    ArrayList servers = this.readServerData(con);
                    this.m_configInfo = configInfo;
                    HashMap tables = this.readTableData(con, servers);
                    this.setGscData(servers, tables);
                    if (this.m_configInfo.getDistCon() == 1) {
                        this.m_DistSvrIdx = (int)((double)this.m_servers.size() * Math.random());
                    }
                    this.connectServers();
                    Logger.info("GSC was read. (" + serverURL + ")");
                    this.closeWithoutException(con);
                }
                catch (SQLException e) {
                    try {
                        Logger.debug(e.getMessage());
                        this.closeWithoutException(con);
                    }
                    catch (Throwable throwable) {
                        this.closeWithoutException(con);
                        throw throwable;
                    }
                    continue;
                }
                break;
            }
            this.closeWithoutException(con);
        }
    }

    protected ArrayList readCollumnData(Connection con, String tableName) throws SQLException {
        ArrayList<PartitionColumnInfo> clmlist = new ArrayList<PartitionColumnInfo>();
        String sql = "select * from FOREST_PARTATR where DBNAME = '" + this.m_dbName + "' " + "and lower(TABLE_NAME) = '" + tableName + "'";
        Statement smt = con.createStatement();
        ResultSet rs = smt.executeQuery(sql);
        while (rs.next()) {
            PartitionColumnInfo clmInfo = new PartitionColumnInfo();
            clmInfo.setName(rs.getString("COLUMN_NAME").toLowerCase());
            clmInfo.setNumber(rs.getInt("COLUMN_NO"));
            int clmType = ((AbstractJdbc2Connection)con).getSQLType(rs.getString("COLUMN_TYPE").toLowerCase());
            clmInfo.setType(clmType);
            clmlist.add(clmInfo);
        }
        smt.close();
        return clmlist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConfigInfo readConfig(Connection con) throws SQLException {
        Statement smt;
        block11: {
            ConfigInfo configInfo2;
            StringBuffer sql = new StringBuffer("select * from FOREST_CONFIG ");
            sql.append("where CONFIGID = '");
            sql.append(this.m_configInfo.getConfigID());
            sql.append("'");
            smt = null;
            try {
                try {
                    smt = con.createStatement();
                    ResultSet rs = smt.executeQuery(sql.toString());
                    rs.next();
                    Date configDate = new Date(rs.getTimestamp("UPDATE_DATE").getTime());
                    if (this.m_configInfo.getConfigDate() != null && configDate.equals(this.m_configInfo.getConfigDate())) break block11;
                    ConfigInfo configInfo = new ConfigInfo(this.m_configInfo.getConfigID());
                    configInfo.setPartitionMode(rs.getBoolean("PERTITION_MODE"));
                    configInfo.setUpdateSyncMode(rs.getBoolean("SYNCRONIZE_MODE"));
                    int reflesh = rs.getInt("CACHE_REFLESH") * 1000;
                    configInfo.setReflesh(reflesh);
                    configInfo.setTimeout(rs.getInt("DEFECT_TIMEOUT"));
                    int distCon = rs.getInt("DISTRIBUTED_CONNECTION");
                    if (distCon == 1 && this.m_configInfo.getDistCon() != distCon) {
                        configInfo.setDistCon(distCon);
                    }
                    configInfo.setRetry(rs.getInt("RETRY_COUNT"));
                    Logger.info("The configuration file was read. (ID:" + configInfo.getConfigID() + ")");
                    configInfo.setConfigDate(configDate);
                    configInfo2 = configInfo;
                    Object var11_11 = null;
                }
                catch (SQLException e) {
                    Logger.info("Reading of a configuration file went wrong. (ID:" + this.m_configInfo.getConfigID() + ")");
                    throw new PSQLException(GT.tr("configration data reading error .(ID:{0}) {1}", new Object[]{this.m_configInfo.getConfigID(), e.getMessage()}), ForestSQLState.INTERNAL_ERROR);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (smt == null) throw throwable;
                    smt.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                // empty catch block
                return configInfo2;
            }
            if (smt == null) return configInfo2;
            smt.close();
            return configInfo2;
        }
        Object var11_12 = null;
        try {}
        catch (SQLException e1) {}
        if (smt == null) return null;
        smt.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData() throws SQLException {
        GscInfo gscInfo = this.getNextGscInfo();
        while (gscInfo != null) {
            Connection con = null;
            try {
                con = gscInfo.getConnection();
                ConfigInfo configInfo = this.readConfig(con);
                ArrayList servers = this.readServerData(con);
                GscData gscData = this;
                synchronized (gscData) {
                    if (configInfo != null) {
                        this.m_configInfo = configInfo;
                        HashMap tables = this.readTableData(con, servers);
                        this.setGscData(servers, tables);
                        this.buildGscInfoList(con, gscInfo.getUrl());
                        if (this.m_configInfo.getDistCon() == 1) {
                            this.m_DistSvrIdx = (int)((double)this.m_servers.size() * Math.random());
                        }
                        this.connectServers();
                    } else if (this.m_servers != null) {
                        this.setGscStatus(servers);
                    }
                }
                Logger.info("GSC was read. (" + gscInfo.getUrl() + ")");
                return;
            }
            catch (SQLException e) {
                Logger.info("Reading of GSC went wrong. (" + gscInfo.getUrl() + ")");
                Logger.info("A server(" + gscInfo.getUrl() + ") is separated.");
                gscInfo.setStatus(-1);
                m_brokenNotifier.notifyGscBroken(gscInfo.getUrl(), e.getMessage(), e.getSQLState());
            }
            finally {
                this.closeWithoutException(con);
            }
            gscInfo = this.getNextGscInfo();
        }
        throw new PSQLException(GT.tr("An effective global system catalog does not exist."), ForestSQLState.INTERNAL_ERROR);
    }

    protected ArrayList readServerData(Connection con) throws SQLException {
        StringBuffer sql = new StringBuffer(256);
        sql.append("select * ");
        sql.append(" from FOREST_SERVER as a, FOREST_SERVDB as b ");
        sql.append(" where a.SERVERID = b.SERVERID ");
        sql.append(" and b.DBNAME = '");
        sql.append(this.m_dbName);
        sql.append("'  order by a.SERVERID");
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        Statement smt = con.createStatement();
        ResultSet rs = smt.executeQuery(sql.toString());
        while (rs.next()) {
            ServerInfo srvInfo = new ServerInfo();
            srvInfo.setId(rs.getInt("SERVERID"));
            srvInfo.setStatus(rs.getInt("STATUS"));
            srvInfo.setUrl(rs.getString("URL"));
            srvInfo.setDbNo(rs.getInt("DBNO"));
            servers.add(srvInfo);
        }
        smt.close();
        return servers;
    }

    protected HashMap readTableData(Connection con, ArrayList serverList) throws SQLException {
        HashLoader hloader = HashLoader.getIncetance(false);
        HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
        HashMap serverMap = this.getServerMap(serverList);
        String sql = "select * from FOREST_TABLEPART where DBNAME = '" + this.m_dbName + "'";
        Statement smt = con.createStatement();
        ResultSet rs = smt.executeQuery(sql);
        while (rs.next()) {
            String className;
            TableInfo tblInfo = new TableInfo();
            String tableName = rs.getString("TABLE_NAME").toLowerCase();
            tblInfo.setName(tableName);
            sql = "select * from FOREST_TABLEPARTDTL where DBNAME = '" + this.m_dbName + "'" + " and lower(TABLE_NAME) = '" + tableName + "'" + " order by PRIORITY";
            Statement smt2 = con.createStatement();
            ResultSet rs2 = smt2.executeQuery(sql);
            while (rs2.next()) {
                Integer dbNo = new Integer(rs2.getInt("DBNO"));
                ServerInfo svrInfo = (ServerInfo)serverMap.get(dbNo);
                int partNo = rs2.getInt("PART_NO");
                tblInfo.setServers(partNo, svrInfo);
            }
            smt2.close();
            tblInfo.setType(rs.getInt("PART_TYPE"));
            tblInfo.setPartitionNum(rs.getInt("PART_COUNT"));
            tblInfo.setStatus(rs.getInt("STATUS"));
            if (tblInfo.isPartition()) {
                ArrayList clmlist = this.readCollumnData(con, tableName);
                tblInfo.setColumnList(clmlist);
            }
            if ((className = rs.getString("HASH_NAME")) == null) {
                tblInfo.setHash(new Hash01());
            } else {
                try {
                    Hash_I hashobj = (Hash_I)hloader.loadClass(className, con).newInstance();
                    tblInfo.setHash(hashobj);
                }
                catch (Exception e) {
                    throw new PSQLException(GT.tr("Partition No decision function is illegal. {0}:{1}", new Object[]{className, e.getMessage()}), ForestSQLState.INTERNAL_ERROR);
                }
            }
            tables.put(tableName, tblInfo);
        }
        smt.close();
        return tables;
    }

    public void run() {
        Logger.info("The updating thread of GSC cash is started.");
        while (true) {
            try {
                int reflesh;
                if (GscData.interrupted() || (reflesh = this.m_configInfo.getReflesh()) == 0) break;
                GscData.sleep(reflesh);
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                this.readData();
            }
            catch (SQLException e1) {
                this.m_thredErr = e1;
                break;
            }
        }
        Logger.info("The updating thread of GSC cash is ended.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDBstatus(ServerInfo serverInfo, String query, Exception ex) {
        int id = serverInfo.getId();
        String url = serverInfo.getUrl();
        String msg = ex.getMessage();
        String status = ex instanceof SQLException ? ((SQLException)ex).getSQLState() : "XX000";
        StringBuffer sqlStatus = new StringBuffer(128);
        sqlStatus.append("update  FOREST_SERVER ");
        sqlStatus.append(" set STATUS = ");
        sqlStatus.append(-1);
        sqlStatus.append(" where SERVERID = ");
        sqlStatus.append(id);
        StringBuffer sqlLog = new StringBuffer(256);
        sqlLog.append("INSERT INTO forest_brokenlog (serverid, datetime, msg, status, client, query) ");
        sqlLog.append("VALUES( ");
        sqlLog.append(id);
        sqlLog.append(", '");
        sqlLog.append(new java.util.Date());
        sqlLog.append("', '");
        sqlLog.append(msg.replaceAll("'", "''"));
        sqlLog.append("', '");
        sqlLog.append(status);
        sqlLog.append("', '");
        sqlLog.append(m_client);
        sqlLog.append("', '");
        sqlLog.append(query.replaceAll("'", "''"));
        sqlLog.append("')");
        m_brokenNotifier.notifyServerBroken(url, msg, status, query);
        ArrayList arrayList = this.m_gscInfoList;
        synchronized (arrayList) {
            boolean updateStatus = false;
            Iterator iter = this.m_gscInfoList.iterator();
            while (iter.hasNext()) {
                GscInfo gscInfo = (GscInfo)iter.next();
                String serverURL = gscInfo.getUrl();
                Logger.debug("updateDBstatus: " + gscInfo.toString());
                if (gscInfo.getId() == id) {
                    m_brokenNotifier.notifyGscBroken(serverURL, msg, status);
                    gscInfo.setStatus(-1);
                    continue;
                }
                if (gscInfo.getStatus() == -1) continue;
                Connection con = null;
                try {
                    con = this.connect(serverURL, this.m_prop);
                    Statement smt = con.createStatement();
                    smt.executeUpdate(sqlStatus.toString());
                    smt.executeUpdate(sqlLog.toString());
                    smt.close();
                    updateStatus = true;
                    this.closeWithoutException(con);
                }
                catch (SQLException e) {
                    try {
                        m_brokenNotifier.notifyGscBroken(serverURL, e.getMessage(), e.getSQLState());
                        gscInfo.setStatus(-1);
                        this.closeWithoutException(con);
                    }
                    catch (Throwable throwable) {
                        this.closeWithoutException(con);
                        throw throwable;
                    }
                }
            }
            if (!updateStatus) {
                this.m_thredErr = new PSQLException(GT.tr("An effective global system catalog does not exist."), ForestSQLState.INTERNAL_ERROR, (Throwable)ex);
            }
        }
    }

    protected boolean buildGscInfoList(Connection con, String serverURL) {
        String sql = "select URL, DBNAME, s.SERVERID, STATUS from FOREST_GSC g, FOREST_SERVER s where g.SERVERID = s.SERVERID";
        ArrayList<GscInfo> servers = new ArrayList<GscInfo>();
        try {
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(sql);
            while (rs.next()) {
                String gscUrl = rs.getString("URL") + rs.getString("DBNAME");
                Logger.debug(" GSC URL    : " + rs.getString("URL"));
                Logger.debug(" GSC DB     : " + rs.getString("DBNAME"));
                Logger.debug(" GSC STATUS : " + rs.getString("STATUS"));
                GscInfo gscInfoNew = new GscInfo(rs.getInt("SERVERID"), rs.getInt("STATUS"), gscUrl);
                if (serverURL.equals(gscUrl)) {
                    servers.add(0, gscInfoNew);
                    continue;
                }
                servers.add(gscInfoNew);
            }
            rs.close();
            smt.close();
        }
        catch (Exception e) {
            return false;
        }
        if (servers.size() > 0) {
            this.m_gscInfoList = servers;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GscInfo getNextGscInfo() {
        Connection con = null;
        ArrayList arrayList = this.m_gscInfoList;
        synchronized (arrayList) {
            Iterator iter = this.m_gscInfoList.iterator();
            while (iter.hasNext()) {
                GscInfo gscInfo = (GscInfo)iter.next();
                if (gscInfo.getStatus() == -1) continue;
                String serverURL = gscInfo.getUrl();
                try {
                    con = this.connect(serverURL, this.m_prop);
                    gscInfo.setConnection(con);
                    return gscInfo;
                }
                catch (SQLException e) {
                    Logger.info("Reading of GSC went wrong. (" + gscInfo.getUrl() + ")");
                    Logger.info("A server(" + gscInfo.getUrl() + ") is separated.");
                    if (DistError.isBroken(e)) {
                        int server_id = gscInfo.getId();
                        Iterator iterator = this.m_servers.iterator();
                        while (iterator.hasNext()) {
                            ServerInfo srvinf = (ServerInfo)iterator.next();
                            if (srvinf.getId() != server_id) continue;
                            srvinf.setStatus(-1);
                            this.updateDBstatus(srvinf, "CONNECT", e);
                            break;
                        }
                    }
                    if (gscInfo.getStatus() == 1) {
                        gscInfo.setStatus(-1);
                        m_brokenNotifier.notifyGscBroken(gscInfo.getUrl(), e.getMessage(), e.getSQLState());
                    }
                    this.closeWithoutException(con);
                }
            }
        }
        return null;
    }

    private boolean closeWithoutException(Connection con) {
        boolean rc = false;
        if (con == null) {
            return rc;
        }
        try {
            con.close();
            rc = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    static {
        m_formatDate = new DateFormat[]{SimpleDateFormat.getDateInstance(1)};
        m_formatTime = new DateFormat[]{SimpleDateFormat.getTimeInstance(1)};
        m_formatTimeStamp = new DateFormat[]{SimpleDateFormat.getDateTimeInstance(1, 1)};
        try {
            m_client = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e1) {
            m_client = "UnknownHost";
        }
        try {
            m_brokenNotifier = (BrokenNotify_I)Class.forName("org.postgresforest.vm.BrokenNotifier").newInstance();
        }
        catch (Exception e) {
            m_brokenNotifier = new NoBrokenNotifier();
        }
    }
}

