/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerLoaderClient;
import org.jboss.remoting.marshal.SerialMarshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.http.HTTPMarshaller;
import org.jboss.remoting.marshal.http.HTTPUnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.marshal.rmi.RMIUnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

public class MarshalFactory {
    private static Map marshallers = new HashMap();
    private static Map unmarshallers = new HashMap();
    private static Map classMarshallers = new HashMap();
    private static Map classUnmarshallers = new HashMap();
    protected static final Logger log = Logger.getLogger(MarshalFactory.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean isDebug = log.isDebugEnabled();

    public static void addMarshaller(Class classType, Marshaller marshaller, UnMarshaller unMarshaller) {
        classMarshallers.put(classType, marshaller);
        classUnmarshallers.put(classType, unMarshaller);
    }

    public static void addMarshaller(String dataType, Marshaller marshaller, UnMarshaller unMarshaller) {
        marshallers.put(dataType, marshaller);
        unmarshallers.put(dataType, unMarshaller);
    }

    public static Marshaller getMarshaller(Class classType) {
        Marshaller marshaller = null;
        Object obj = classMarshallers.get(classType);
        if (obj != null && obj instanceof Marshaller) {
            marshaller = (Marshaller)obj;
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + marshaller));
            }
        } else if (isTrace) {
            log.trace((Object)("Could not find marshaller for class type '" + classType + "'.  Object in collection is " + obj));
        }
        return marshaller;
    }

    public static Marshaller getMarshaller(Class classType, String serializationType) {
        Marshaller marshaller = MarshalFactory.getMarshaller(classType);
        if (marshaller instanceof SerialMarshaller) {
            ((SerialMarshaller)marshaller).setSerializationType(serializationType);
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(Class classType) {
        UnMarshaller unmarshaller = null;
        Object obj = classUnmarshallers.get(classType);
        if (obj != null && obj instanceof UnMarshaller) {
            unmarshaller = (UnMarshaller)obj;
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + unmarshaller));
            }
        } else if (isTrace) {
            log.trace((Object)("Could not find unmarshaller for class type '" + classType + "'.  Object in collection is " + obj));
        }
        return unmarshaller;
    }

    public static UnMarshaller getUnMarshaller(Class classType, String serializationType) {
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(classType);
        if (unmarshaller instanceof SerializableUnMarshaller) {
            ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller(String dataType) {
        Marshaller marshaller = null;
        Object obj = marshallers.get(dataType);
        if (obj != null && obj instanceof Marshaller) {
            marshaller = (Marshaller)obj;
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + marshaller));
            }
        } else if (isTrace) {
            log.trace((Object)("Could not find marshaller for data type '" + dataType + "'.  Object in collection is " + obj));
        }
        return marshaller;
    }

    public static Marshaller getMarshaller(String dataType, String serializationType) {
        Marshaller marshaller = MarshalFactory.getMarshaller(dataType);
        if (marshaller instanceof SerializableMarshaller) {
            ((SerializableMarshaller)marshaller).setSerializationType(serializationType);
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(String dataType, String serializationType) {
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(dataType);
        if (unmarshaller instanceof SerializableUnMarshaller) {
            ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
        }
        return unmarshaller;
    }

    public static UnMarshaller getUnMarshaller(String dataType) {
        UnMarshaller unmarshaller = null;
        Object obj = unmarshallers.get(dataType);
        if (obj != null && obj instanceof UnMarshaller) {
            unmarshaller = (UnMarshaller)obj;
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + unmarshaller));
            }
        } else if (isTrace) {
            log.trace((Object)("Could not find unmarshaller for data type '" + dataType + "'.  Object in collection is " + obj));
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller(InvokerLocator locator, ClassLoader classLoader) {
        Map params;
        String serializationType = locator.findSerializationType();
        Marshaller marshaller = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            InvokerLocator loaderLocator;
            String dataType = (String)params.get("datatype");
            if (dataType == null) {
                dataType = (String)params.get("dataType");
            }
            if (dataType != null) {
                marshaller = MarshalFactory.getMarshaller(dataType);
            }
            if (marshaller == null) {
                String marshallerFQN;
                if (isTrace) {
                    log.trace((Object)("Could not look up marshaller by data type ('" + dataType + "').  Will try to load dynamically."));
                }
                if ((marshaller = MarshalFactory.loadMarshaller(marshallerFQN = (String)params.get("marshaller"))) != null) {
                    String unmarshallerFQN;
                    UnMarshaller unmarshaller;
                    if (isTrace) {
                        log.trace((Object)"Found marshaller by loading locally.");
                    }
                    if ((unmarshaller = MarshalFactory.loadUnMarshaller(unmarshallerFQN = (String)params.get("unmarshaller"))) != null) {
                        MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                    }
                }
            }
            if (marshaller == null && isTrace) {
                log.trace((Object)"Tried to find marshaller from locator by both data type and class name but was unsuccessful.  Will try to load it from remote server.");
            }
            if (marshaller == null && dataType != null && (loaderLocator = MarshallLoaderFactory.convertLocator(locator)) != null) {
                marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
                UnMarshaller unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
                if (unmarshaller != null) {
                    unmarshaller.setClassLoader(classLoader);
                }
                if (isDebug) {
                    log.debug((Object)("Remotely loaded marshaller: " + marshaller));
                    log.debug((Object)("Remotely loaded unmarshaller: " + unmarshaller));
                }
                if (marshaller != null && unmarshaller != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
        }
        if (marshaller != null) {
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + marshaller));
            }
        }
        if (marshaller instanceof SerialMarshaller) {
            ((SerialMarshaller)marshaller).setSerializationType(serializationType);
        }
        return marshaller;
    }

    private static Marshaller loadMarshaller(String marshallerFQN) {
        Marshaller marshaller = null;
        if (marshallerFQN != null) {
            try {
                Class<?> marshallerClass = Class.forName(marshallerFQN);
                marshaller = (Marshaller)marshallerClass.newInstance();
            }
            catch (Exception e) {
                log.warn((Object)("Found marshaller fully qualified class name within locator parameters, but was unable to load class: " + marshallerFQN));
            }
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(InvokerLocator locator, ClassLoader classLoader) {
        Map params;
        String serializationType = locator.findSerializationType();
        UnMarshaller unmarshaller = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            String dataType = (String)params.get("datatype");
            if (dataType == null) {
                dataType = (String)params.get("dataType");
            }
            if (dataType != null) {
                unmarshaller = MarshalFactory.getUnMarshaller(dataType);
            }
            if (unmarshaller == null) {
                String marshallerFQN;
                Marshaller marshaller;
                String unmarshallerFQN;
                if (isTrace) {
                    log.trace((Object)("Could not find unmarshaller by data type ('" + dataType + "').  Will try to load dynamically."));
                }
                if ((unmarshaller = MarshalFactory.loadUnMarshaller(unmarshallerFQN = (String)params.get("unmarshaller"))) != null && (marshaller = MarshalFactory.loadMarshaller(marshallerFQN = (String)params.get("marshaller"))) != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
            if (isTrace && unmarshaller == null) {
                log.trace((Object)"Tried to find unmarshaller from locator by both data type and class name but was unsuccessful.");
            }
            if (unmarshaller == null && dataType != null) {
                InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
                unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
                if (unmarshaller != null) {
                    unmarshaller.setClassLoader(classLoader);
                }
                Marshaller marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
                if (isTrace) {
                    log.trace((Object)("Remotely loaded marshaller: " + marshaller));
                    log.trace((Object)("Remotely loaded unmarshaller: " + unmarshaller));
                }
                if (marshaller != null && unmarshaller != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
        }
        if (unmarshaller != null) {
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)("Could not clone " + unmarshaller));
            }
        }
        if (unmarshaller instanceof SerializableUnMarshaller) {
            ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
        }
        return unmarshaller;
    }

    private static UnMarshaller loadUnMarshaller(String unmarshallerFQN) {
        UnMarshaller unmarshaller = null;
        if (unmarshallerFQN != null) {
            try {
                Class<?> unmarshallerClass = Class.forName(unmarshallerFQN);
                unmarshaller = (UnMarshaller)unmarshallerClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Found unmarshaller fully qualified class name within locator parameters, but was unable to load class: " + unmarshallerFQN), (Throwable)e);
            }
        }
        return unmarshaller;
    }

    static {
        try {
            marshallers.put("serializable", new SerializableMarshaller());
            unmarshallers.put("serializable", new SerializableUnMarshaller());
            marshallers.put("http", new HTTPMarshaller());
            unmarshallers.put("http", new HTTPUnMarshaller());
            marshallers.put("rmi", new RMIMarshaller());
            unmarshallers.put("rmi", new RMIUnMarshaller());
        }
        catch (Exception e) {
            log.error((Object)"Could not statically load default marshallers.", (Throwable)e);
        }
    }
}

