/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobRelationMasterDAOImpl
implements JobRelationMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobRelationMasterDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobRelationMasterPK pk, JobRelationMasterBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_relation_mst WHERE job_id = ? AND parent_job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setString(2, pk.getParent_job_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobRelationMaster data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setJob_id(res.getString("job_id"));
                ejb.setParent_job_id(res.getString("parent_job_id"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobRelationMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        m_log.debug((Object)("store() end : " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobRelationMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_relation_mst WHERE job_id = ? AND parent_job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setString(2, pk.getParent_job_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobRelationMasterPK create(JobRelationMasterBean ejb) throws CreateException, EJBException {
        JobRelationMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_relation_mst (");
                sql.append("job_id, ");
                sql.append("parent_job_id) ");
                sql.append("VALUES (?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getJob_id());
                stmt.setString(2, ejb.getParent_job_id());
                int row = stmt.executeUpdate();
                pk = new JobRelationMasterPK(ejb.getJob_id(), ejb.getParent_job_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobRelationMasterPK> ret = new ArrayList<JobRelationMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT job_id, parent_job_id FROM cc_job_relation_mst";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobRelationMasterPK pk = new JobRelationMasterPK(res.getString("job_id"), res.getString("parent_job_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobRelationMasterPK findByPrimaryKey(JobRelationMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT job_id, parent_job_id FROM cc_job_relation_mst WHERE job_id = ? AND parent_job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setString(2, pk.getParent_job_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobRelationMasterPK jobRelationMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobRelationMasterPK;
        }
        try {
            try {
                String msg = "JobRelationMasterDAOImpl.findByPrimaryKey() : id=" + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByParentJobId(String parent_job_id) throws FinderException {
        m_log.debug((Object)("findByParentJobId() start : " + parent_job_id));
        ArrayList<JobRelationMasterPK> ret = new ArrayList<JobRelationMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT job_id, parent_job_id FROM cc_job_relation_mst WHERE parent_job_id = ? ORDER BY job_id ASC";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, parent_job_id);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobRelationMasterPK pk = new JobRelationMasterPK(res.getString("job_id"), res.getString("parent_job_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByParentJobId() error : " + parent_job_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByParentJobId() error : " + parent_job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByParentJobId() error : " + parent_job_id + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByParentJobId() end : " + parent_job_id));
        return ret;
    }

    public JobRelationMasterPK findByJobId(String job_id) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            JobRelationMasterPK pk;
            m_log.debug((Object)("findByJobId() start : " + job_id));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT job_id, parent_job_id FROM cc_job_relation_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, job_id);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobRelationMasterPK jobRelationMasterPK = pk = new JobRelationMasterPK(res.getString("job_id"), res.getString("parent_job_id"));
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByJobId() end : " + job_id));
            return jobRelationMasterPK;
        }
        try {
            try {
                String msg = "JobRelationMasterDAOImpl.findByJobId() : id=" + job_id + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByJobId() end : " + job_id));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getJobsList(String jobId) throws FinderException {
        m_log.debug((Object)("getJobsList() start : " + jobId));
        ArrayList<Hashtable> jobList = new ArrayList<Hashtable>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("parentJobId", "TOP");
        ht.put("jobId", jobId);
        m_log.debug((Object)("getJobsList() MasterJob id : " + jobId + ", " + "TOP"));
        jobList.add(ht);
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT job_id FROM cc_job_relation_mst WHERE parent_job_id = ? ORDER BY job_id ASC";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, jobId);
                ArrayList tmpJobList = new ArrayList();
                res = stmt.executeQuery();
                while (res.next()) {
                    Hashtable<String, String> ht2 = new Hashtable<String, String>();
                    ht2.put("parentJobId", jobId);
                    ht2.put("jobId", res.getString("job_id"));
                    tmpJobList.add(ht2);
                }
                res.close();
                for (Hashtable hashtable : tmpJobList) {
                    jobList.add(hashtable);
                    this.getJobsListSub((String)hashtable.get("jobId"), jobList, stmt);
                }
                Object var12_12 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("getJobsList() error : " + jobId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("getJobsList() error : " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("getJobsList() error : " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("getJobsList() end : " + jobId));
        return jobList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getJobsListSub(String jobId, ArrayList ret, PreparedStatement stmt) throws FinderException {
        m_log.debug((Object)("getJobsListSub() start : " + jobId));
        ArrayList<Hashtable> tmp_ret = new ArrayList<Hashtable>();
        ResultSet res = null;
        Hashtable ht2 = null;
        try {
            try {
                stmt.setString(1, jobId);
                res = stmt.executeQuery();
                while (res.next()) {
                    ht2 = new Hashtable();
                    ht2.put("parentJobId", jobId);
                    ht2.put("jobId", res.getString("job_id"));
                    tmp_ret.add(ht2);
                }
                res.close();
                for (Hashtable ht2 : tmp_ret) {
                    ret.add(ht2);
                    this.getJobsListSub((String)ht2.get("jobId"), ret, stmt);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("getJobsListSub() error: " + jobId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (res == null) throw throwable;
                res.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("getJobsListSub() error : " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("getJobsListSub() error : " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        m_log.debug((Object)("getJobsListSub() end : " + jobId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTopJobId(String jobId) throws FinderException {
        m_log.debug((Object)("getTopJobId() start : " + jobId));
        Connection conn = null;
        PreparedStatement stmt = null;
        String topJobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT parent_job_id FROM cc_job_relation_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                topJobId = this.getTopJobIdSub(jobId, stmt);
            }
            catch (SQLException e) {
                m_log.error((Object)("getTopJobId() error : " + jobId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("getJobsList() error : " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("getJobsList() error : " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("getTopJobId() end : " + jobId));
        return topJobId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTopJobIdSub(String jobId, PreparedStatement stmt) throws FinderException {
        ResultSet res;
        block10: {
            String string;
            m_log.debug((Object)("getTopJobIdSub() start : " + jobId));
            res = null;
            String parentJobId = null;
            try {
                try {
                    stmt.setString(1, jobId);
                    res = stmt.executeQuery();
                    if (res.next()) {
                        parentJobId = res.getString("parent_job_id");
                    }
                    res.close();
                    if (parentJobId == null || parentJobId.equals("TOP")) break block10;
                    string = this.getTopJobId(parentJobId);
                    Object var7_7 = null;
                }
                catch (SQLException e) {
                    m_log.error((Object)("getTopJobIdSub() error: " + jobId + " SQLException"));
                    throw new EJBException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (res == null) throw throwable;
                    res.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    m_log.error((Object)("getTopJobIdSub() error : " + jobId + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
            }
            try {}
            catch (SQLException e1) {
                m_log.error((Object)("getTopJobIdSub() error : " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            if (res == null) return string;
            res.close();
            return string;
        }
        Object var7_8 = null;
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("getTopJobIdSub() error : " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        m_log.debug((Object)("getTopJobIdSub() end : " + jobId));
        return jobId;
    }
}

