/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.il.uil2.SocketManagerHandler;
import org.jboss.mq.il.uil2.msgs.BaseMsg;
import org.jboss.util.stream.NotifyingBufferedInputStream;
import org.jboss.util.stream.NotifyingBufferedOutputStream;

public class SocketManager {
    private static Logger log = Logger.getLogger(SocketManager.class);
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    private static final int STOPPING = 2;
    private static SynchronizedInt taskID = new SynchronizedInt(0);
    private Socket socket;
    private ObjectInputStream in;
    NotifyingBufferedInputStream bufferedInput;
    private ObjectOutputStream out;
    NotifyingBufferedOutputStream bufferedOutput;
    private Thread writeThread;
    private Thread readThread;
    PooledExecutor pool;
    private int readState = 0;
    private int writeState = 0;
    private SynchronizedBoolean running = new SynchronizedBoolean(false);
    private LinkedQueue sendQueue;
    private ConcurrentHashMap replyMap;
    private SocketManagerHandler handler;
    private int bufferSize = 1;
    private int chunkSize = 0x40000000;
    private boolean trace;

    public SocketManager(Socket s) throws IOException {
        this.socket = s;
        this.sendQueue = new LinkedQueue();
        this.replyMap = new ConcurrentHashMap();
        this.trace = log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ThreadGroup tg) {
        InetAddress inetAddr;
        if (this.trace) {
            log.trace("start called", new Exception("Start stack trace"));
        }
        String ipAddress = (inetAddr = this.socket.getInetAddress()) != null ? inetAddr.getHostAddress() : "<unknown>";
        ipAddress = ipAddress + ":" + this.socket.getPort();
        if (this.pool == null) {
            this.pool = new PooledExecutor(5);
            this.pool.setMinimumPoolSize(1);
            this.pool.setKeepAliveTime(60000L);
            this.pool.runWhenBlocked();
            String id = "SocketManager.MsgPool@" + Integer.toHexString(System.identityHashCode(this)) + " client=" + ipAddress;
            this.pool.setThreadFactory(new UILThreadFactory(id));
        }
        ReadTask readTask = new ReadTask();
        this.readThread = new Thread(tg, readTask, "UIL2.SocketManager.ReadTask#" + taskID.increment() + " client=" + ipAddress);
        this.readThread.setDaemon(true);
        WriteTask writeTask = new WriteTask();
        this.writeThread = new Thread(tg, writeTask, "UIL2.SocketManager.WriteTask#" + taskID.increment() + " client=" + ipAddress);
        this.writeThread.setDaemon(true);
        SynchronizedBoolean synchronizedBoolean = this.running;
        synchronized (synchronizedBoolean) {
            this.readState = 1;
            this.writeState = 1;
            this.running.set(true);
        }
        try {
            this.readThread.start();
            this.writeThread.start();
        }
        catch (Throwable t) {
            try {
                this.stop();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            log.warn("Error starting socket manager threads", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SynchronizedBoolean synchronizedBoolean = this.running;
        synchronized (synchronizedBoolean) {
            if (this.trace) {
                log.trace("stop() " + this.readThread + " " + this.writeThread);
            }
            if (this.readState == 1) {
                this.readState = 2;
                this.readThread.interrupt();
            }
            if (this.writeState == 1) {
                this.writeState = 2;
                this.writeThread.interrupt();
            }
            this.running.set(false);
            if (this.pool != null) {
                this.pool.shutdownNow();
                this.pool = null;
            }
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setHandler(SocketManagerHandler handler) {
        this.handler = handler;
        if (this.bufferedInput != null) {
            this.bufferedInput.setStreamListener(handler);
        }
        if (this.bufferedOutput != null) {
            this.bufferedOutput.setStreamListener(handler);
        }
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
    }

    public void sendMessage(BaseMsg msg) throws Exception {
        this.internalSendMessage(msg, true);
        if (msg.error != null) {
            if (this.trace) {
                log.trace("sendMessage will throw error", msg.error);
            }
            throw msg.error;
        }
    }

    public void sendReply(BaseMsg msg) throws Exception {
        msg.trimReply();
        this.internalSendMessage(msg, false);
    }

    public void sendOneWay(BaseMsg msg) throws Exception {
        msg.getMsgID();
        this.internalSendMessage(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSendMessage(BaseMsg msg, boolean waitOnReply) throws Exception {
        if (!this.running.get()) {
            throw new IOException("Client is not connected");
        }
        if (waitOnReply) {
            BaseMsg baseMsg = msg;
            synchronized (baseMsg) {
                msg.getMsgID();
                if (this.trace) {
                    log.trace("Begin internalSendMessage, round-trip msg=" + msg);
                }
                this.replyMap.put(msg, msg);
                this.sendQueue.put(msg);
                msg.wait();
            }
        } else {
            if (this.trace) {
                log.trace("Begin internalSendMessage, one-way msg=" + msg);
            }
            this.sendQueue.put(msg);
        }
        if (this.trace) {
            log.trace("End internalSendMessage, msg=" + msg);
        }
    }

    static class UILThreadFactory
    implements ThreadFactory {
        private String id;
        private int count;

        UILThreadFactory(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread newThread(Runnable command) {
            UILThreadFactory uILThreadFactory = this;
            synchronized (uILThreadFactory) {
                ++this.count;
            }
            Thread t = new Thread(command, "UIL2(" + this.id + ")#" + this.count);
            return t;
        }
    }

    public class WriteTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug("Begin WriteTask.run " + Thread.currentThread());
            try {
                SocketManager.this.bufferedOutput = new NotifyingBufferedOutputStream(SocketManager.this.socket.getOutputStream(), SocketManager.this.bufferSize, SocketManager.this.chunkSize, SocketManager.this.handler);
                SocketManager.this.out = new ObjectOutputStream(SocketManager.this.bufferedOutput);
                log.debug("Created ObjectOutputStream");
            }
            catch (IOException e) {
                this.handleStop(null, "Failed to create ObjectOutputStream", e);
                return;
            }
            while (true) {
                BaseMsg msg = null;
                SynchronizedBoolean synchronizedBoolean = SocketManager.this.running;
                synchronized (synchronizedBoolean) {
                    if (SocketManager.this.writeState != 1) {
                        break;
                    }
                }
                try {
                    msg = (BaseMsg)SocketManager.this.sendQueue.poll(10000L);
                    if (msg == null) continue;
                    if (SocketManager.this.trace) {
                        log.trace("Write msg: " + msg);
                    }
                    msg.write(SocketManager.this.out);
                    SocketManager.this.out.reset();
                    SocketManager.this.out.flush();
                }
                catch (InterruptedException e) {
                    this.handleStop(msg, "WriteTask was interrupted", e);
                    break;
                }
                catch (IOException e) {
                    this.handleStop(msg, "Exiting on IOE", e);
                    break;
                }
                catch (Throwable e) {
                    this.handleStop(msg, "Failed to write msgType:" + msg, e);
                    break;
                }
            }
            log.debug("End WriteTask.run " + Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleStop(BaseMsg msg, String error, Throwable e) {
            block19: {
                block18: {
                    Object object = SocketManager.this.running;
                    synchronized (object) {
                        SocketManager.this.writeState = 2;
                        SocketManager.this.running.set(false);
                    }
                    if (e instanceof InterruptedException || e instanceof IOException) {
                        if (SocketManager.this.trace) {
                            log.trace(error, e);
                        }
                    } else {
                        log.debug(error, e);
                    }
                    if (msg != null) {
                        msg.setError(e);
                        object = msg;
                        synchronized (object) {
                            msg.notify();
                        }
                    }
                    object = SocketManager.this.running;
                    synchronized (object) {
                        SocketManager.this.writeState = 0;
                        if (SocketManager.this.readState == 1) {
                            SocketManager.this.readState = 2;
                            SocketManager.this.readThread.interrupt();
                        }
                    }
                    try {
                        SocketManager.this.out.close();
                    }
                    catch (Exception ignored) {
                        if (!SocketManager.this.trace) break block18;
                        log.trace(ignored.getMessage(), ignored);
                    }
                }
                try {
                    SocketManager.this.socket.close();
                }
                catch (Exception ignored) {
                    if (!SocketManager.this.trace) break block19;
                    log.trace(ignored.getMessage(), ignored);
                }
            }
        }
    }

    public class ReadTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte msgType = 0;
            log.debug("Begin ReadTask.run " + Thread.currentThread());
            try {
                SocketManager.this.bufferedInput = new NotifyingBufferedInputStream(SocketManager.this.socket.getInputStream(), SocketManager.this.bufferSize, SocketManager.this.chunkSize, SocketManager.this.handler);
                SocketManager.this.in = new ObjectInputStream(SocketManager.this.bufferedInput);
                log.debug("Created ObjectInputStream");
            }
            catch (IOException e) {
                this.handleStop("Failed to create ObjectInputStream", e);
                return;
            }
            block18: while (true) {
                try {
                    BaseMsg msg;
                    int msgID;
                    while (true) {
                        msgType = SocketManager.this.in.readByte();
                        msgID = SocketManager.this.in.readInt();
                        if (SocketManager.this.trace) {
                            log.trace("Read msgType: " + BaseMsg.toString(msgType) + ", msgID: " + msgID);
                        }
                        BaseMsg key = new BaseMsg(msgType, msgID);
                        msg = (BaseMsg)SocketManager.this.replyMap.remove(key);
                        if (msg != null) break;
                        msg = BaseMsg.createMsg(msgType);
                        msg.setMsgID(msgID);
                        msg.read(SocketManager.this.in);
                        if (SocketManager.this.trace) {
                            log.trace("Read new msg: " + msg);
                        }
                        if (SocketManager.this.pool == null) break block18;
                        msg.setHandler(this);
                        SocketManager.this.pool.execute(msg);
                    }
                    if (SocketManager.this.trace) {
                        log.trace("Found replyMap msg: " + msg);
                    }
                    msg.setMsgID(msgID);
                    try {
                        msg.read(SocketManager.this.in);
                        if (!SocketManager.this.trace) continue;
                        log.trace("Read msg reply: " + msg);
                    }
                    catch (Throwable e) {
                        msg.setError(e);
                        throw e;
                    }
                    finally {
                        BaseMsg baseMsg = msg;
                        synchronized (baseMsg) {
                            msg.notify();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    this.handleStop("Failed to read msgType:" + msgType, e);
                    break;
                }
                catch (IOException e) {
                    this.handleStop("Exiting on IOE", e);
                    break;
                }
                catch (InterruptedException e) {
                    this.handleStop("Exiting on interrupt", e);
                    break;
                }
                catch (Throwable e) {
                    this.handleStop("Exiting on unexpected error in read task", e);
                    break;
                }
            }
            log.debug("End ReadTask.run " + Thread.currentThread());
        }

        public void handleMsg(BaseMsg msg) {
            block9: {
                try {
                    SocketManager.this.handler.handleMsg(msg);
                }
                catch (Throwable e) {
                    if (e instanceof JMSException || !SocketManager.this.running.get()) {
                        log.trace("Failed to handle: " + msg.toString(), e);
                    } else if (e instanceof RuntimeException || e instanceof Error) {
                        log.error("Failed to handle: " + msg.toString(), e);
                    } else {
                        log.debug("Failed to handle: " + msg.toString(), e);
                    }
                    msg.setError(e);
                    try {
                        SocketManager.this.internalSendMessage(msg, false);
                    }
                    catch (Exception ie) {
                        if (SocketManager.this.running.get()) {
                            log.debug("Failed to send error reply", ie);
                            break block9;
                        }
                        log.trace("Failed to send error reply", ie);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleStop(String error, Throwable e) {
            block16: {
                block15: {
                    SynchronizedBoolean synchronizedBoolean = SocketManager.this.running;
                    synchronized (synchronizedBoolean) {
                        SocketManager.this.readState = 2;
                        SocketManager.this.running.set(false);
                    }
                    if (e instanceof IOException || e instanceof InterruptedException) {
                        if (SocketManager.this.trace) {
                            log.trace(error, e);
                        }
                    } else {
                        log.debug(error, e);
                    }
                    this.replyAll(e);
                    if (SocketManager.this.handler != null) {
                        SocketManager.this.handler.asynchFailure(error, e);
                        SocketManager.this.handler.close();
                    }
                    synchronizedBoolean = SocketManager.this.running;
                    synchronized (synchronizedBoolean) {
                        SocketManager.this.readState = 0;
                        if (SocketManager.this.writeState == 1) {
                            SocketManager.this.writeState = 2;
                            SocketManager.this.writeThread.interrupt();
                        }
                    }
                    try {
                        SocketManager.this.in.close();
                    }
                    catch (Exception ignored) {
                        if (!SocketManager.this.trace) break block15;
                        log.trace(ignored.getMessage(), ignored);
                    }
                }
                try {
                    SocketManager.this.socket.close();
                }
                catch (Exception ignored) {
                    if (!SocketManager.this.trace) break block16;
                    log.trace(ignored.getMessage(), ignored);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replyAll(Throwable e) {
            Thread.interrupted();
            Iterator iterator = SocketManager.this.replyMap.keySet().iterator();
            while (iterator.hasNext()) {
                BaseMsg msg = (BaseMsg)iterator.next();
                msg.setError(e);
                BaseMsg baseMsg = msg;
                synchronized (baseMsg) {
                    msg.notify();
                }
                iterator.remove();
            }
        }
    }
}

