/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util.code;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorItemTreeItem
implements Serializable {
    private static final long serialVersionUID = -8592461412968942952L;
    private CollectorCategoryMstData category = null;
    private CollectorItemTreeItem parent = null;
    private Object data = null;
    private ArrayList<CollectorItemTreeItem> children = null;
    private String collectMethod;
    private CollectorDeviceInfoData deviceData = null;

    public CollectorItemTreeItem(CollectorItemTreeItem parent, Object data, String collectMethod, CollectorDeviceInfoData deviceData) {
        this.collectMethod = collectMethod;
        this.deviceData = deviceData != null ? deviceData : new CollectorDeviceInfoData(null, null, "", "", new Long(-1L), null, null);
        if (data instanceof CollectorCategoryMstData) {
            this.setCategory((CollectorCategoryMstData)data);
        } else if (data instanceof CollectorItemCodeMstData) {
            this.setCategory(parent.getCategory());
        }
        this.setParent(parent);
        this.data = data;
        if (parent != null) {
            parent.addChildren(this);
        }
        this.children = new ArrayList();
    }

    private void setParent(CollectorItemTreeItem parent) {
        this.parent = parent;
    }

    private void addChildren(CollectorItemTreeItem child) {
        child.setParent(this);
        this.children.add(child);
    }

    public String getItemCode() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getItemCode();
        }
        return null;
    }

    public String getItemName() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getItemName();
        }
        return null;
    }

    public boolean hasBreakdown() {
        return this.children.size() != 0;
    }

    public boolean isDeviceFlag() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getDeviceSupport() == 1;
        }
        return false;
    }

    public String getDeviceType() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getDeviceType();
        }
        return null;
    }

    public boolean isRangeFixed() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getGraphRange() == 1;
        }
        return false;
    }

    public String getMeasure() {
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getMeasure();
        }
        return null;
    }

    public CollectorCategoryMstData getCategory() {
        return this.category;
    }

    private void setCategory(CollectorCategoryMstData category) {
        this.category = category;
    }

    public ArrayList<CollectorItemTreeItem> getChildren() {
        return this.children;
    }

    public String getCode() {
        if (this.data instanceof CollectorCategoryMstData) {
            return ((CollectorCategoryMstData)this.data).getCategoryCode();
        }
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getItemCode();
        }
        return null;
    }

    public String getName() {
        if (this.data instanceof CollectorCategoryMstData) {
            return ((CollectorCategoryMstData)this.data).getCategoryName();
        }
        if (this.data instanceof CollectorItemCodeMstData) {
            return ((CollectorItemCodeMstData)this.data).getItemName();
        }
        return null;
    }

    public String getFullName() {
        if (this.data instanceof CollectorCategoryMstData) {
            return ((CollectorCategoryMstData)this.data).getCategoryName();
        }
        if (this.data instanceof CollectorItemCodeMstData) {
            String itemName = ((CollectorItemCodeMstData)this.data).getItemName();
            if (this.deviceData != null && this.deviceData.getDeviceType() != null && !"".equals(this.deviceData.getDeviceType())) {
                itemName = itemName + "[" + this.deviceData.getDisplayName() + "]";
            }
            return itemName;
        }
        return null;
    }

    public CollectorItemTreeItem getParent() {
        return this.parent;
    }

    public int size() {
        return this.children.size();
    }

    public CollectorDeviceInfoData getDeviceData() {
        return this.deviceData;
    }

    public String getCollectMethod() {
        return this.collectMethod;
    }

    public String getCollectorItemInfoData() {
        if (this.data instanceof CollectorCategoryMstData) {
            return ((CollectorCategoryMstData)this.data).getCategoryName();
        }
        if (this.data instanceof CollectorItemCodeMstData) {
            String itemName = ((CollectorItemCodeMstData)this.data).getItemName();
            if (this.deviceData != null) {
                itemName = itemName + "[" + this.deviceData.getDisplayName() + "]";
            }
            return itemName;
        }
        return null;
    }

    public boolean isCategoryItem() {
        return this.data instanceof CollectorCategoryMstData;
    }
}

