/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatedDataDAO {
    protected static Log m_log = LogFactory.getLog(CalculatedDataDAO.class);

    public List<CollectedDataInfo> select(String collectorID, String itemCode, String displayName, String facilityID, Date startDate, Date stopDate) throws EJBException {
        m_log.debug((Object)("select() start :" + collectorID + " " + itemCode + " " + displayName + " " + facilityID));
        ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT DATE_TIME,VALUE FROM CC_CALCULATED_DATA WHERE COLLECTORID=? AND ITEM_CODE=? AND DISPLAY_NAME=? AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ?ORDER BY DATE_TIME";
            stmt = conn.prepareStatement(sql);
            Timestamp start = new Timestamp(startDate.getTime());
            Timestamp stop = new Timestamp(stopDate.getTime());
            stmt.setString(1, collectorID);
            stmt.setString(2, itemCode);
            stmt.setString(3, displayName);
            stmt.setString(4, facilityID);
            stmt.setTimestamp(5, start);
            stmt.setTimestamp(6, stop);
            res = stmt.executeQuery();
            while (res.next()) {
                Date d = new Date(res.getTimestamp("DATE_TIME").getTime());
                CollectedDataInfo data = res.getObject("VALUE") != null ? new CollectedDataInfo(facilityID, itemCode, displayName, d, res.getDouble("VALUE")) : new CollectedDataInfo(facilityID, itemCode, displayName, d, Double.NaN);
                ret.add(data);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("select() error :" + facilityID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("select() error :" + facilityID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("select() end   :" + collectorID + " " + itemCode + " " + displayName + " " + facilityID));
        return ret;
    }

    public ArrayList<CollectedDataInfo> select(String collectorID, String facilityID, Date startDate, Date stopDate) throws EJBException {
        m_log.debug((Object)("select() start :" + collectorID + " " + facilityID));
        ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT date_time, item_code, display_name, value FROM cc_calculated_data WHERE collectorid = ? AND facilityid = ? AND date_time >= ? AND date_time < ?";
            stmt = conn.prepareStatement(sql);
            Timestamp startTimestamp = new Timestamp(startDate.getTime());
            Timestamp stopTimestamp = new Timestamp(stopDate.getTime());
            stmt.setString(1, collectorID);
            stmt.setString(2, facilityID);
            stmt.setTimestamp(3, startTimestamp);
            stmt.setTimestamp(4, stopTimestamp);
            res = stmt.executeQuery();
            while (res.next()) {
                if (res.getObject("VALUE") == null) continue;
                ret.add(new CollectedDataInfo(facilityID, res.getString("ITEM_CODE"), res.getString("DISPLAY_NAME"), res.getTimestamp("DATE_TIME"), res.getDouble("VALUE")));
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("select() error :" + collectorID + " " + facilityID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("select() error :" + collectorID + " " + facilityID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("select() end   :" + collectorID + " " + facilityID));
        return ret;
    }

    public void delete(String collectorID) throws EJBException {
        m_log.debug((Object)("delete() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM CC_CALCULATED_DATA WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("delete() error :" + collectorID + " EJBException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("delete() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("delete() end   :" + collectorID));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(String collectorID, CollectedDataInfo data) throws EJBException {
        m_log.debug((Object)("insert() start : " + collectorID + " " + data.getItemCode() + " " + data.getDisplayName() + " " + data.getFacilityId()));
        Connection conn = null;
        PreparedStatement stmt = null;
        Timestamp time = new Timestamp(data.getDate().getTime());
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO CC_CALCULATED_DATA (COLLECTORID, ITEM_CODE, DISPLAY_NAME, DATE_TIME, FACILITYID, VALUE) values (?,?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setString(2, data.getItemCode());
                stmt.setString(3, data.getDisplayName());
                stmt.setTimestamp(4, time);
                stmt.setString(5, data.getFacilityId());
                if (Double.isNaN(data.getValue())) {
                    stmt.setNull(6, 8);
                } else {
                    stmt.setDouble(6, data.getValue());
                }
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    throw new SQLException(msg);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("insert() error :" + collectorID + " EJBException "), (Throwable)e);
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insert() error :" + collectorID + " EJBException "), (Throwable)e1);
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insert() end   : " + collectorID + " " + data.getItemCode() + " " + data.getDisplayName() + " " + data.getFacilityId()));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("insert() error :" + collectorID + " EJBException "), (Throwable)e1);
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("insert() end   : " + collectorID + " " + data.getItemCode() + " " + data.getDisplayName() + " " + data.getFacilityId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteOverPresave(String collectorID, Date startDate) throws EJBException {
        m_log.debug((Object)("deleteOrverPresave() start :" + collectorID + " " + startDate.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        Timestamp time = new Timestamp(startDate.getTime());
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM CC_CALCULATED_DATA WHERE COLLECTORID = ? AND DATE_TIME < ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setTimestamp(2, time);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
                throw new EJBException(e.getMessage());
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteOrverPresave() end :" + collectorID + " " + startDate.toString() + "  EJBException "));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("deleteOrverPresave() end :" + collectorID + " " + startDate.toString() + "  EJBException "));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recountFromDB(String collectorID) throws EJBException {
        int ret;
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block26: {
            int n;
            block25: {
                int n2;
                block24: {
                    m_log.debug((Object)("recountFromDB() start :" + collectorID));
                    conn = null;
                    stmt = null;
                    res = null;
                    ret = -1;
                    try {
                        try {
                            conn = ConnectionManager.getConnectionManager().getConnection();
                            String preQuery = "SELECT item_code, facilityid FROM cc_calculated_data where collectorid = ? LIMIT 1";
                            stmt = conn.prepareStatement("SELECT item_code, facilityid FROM cc_calculated_data where collectorid = ? LIMIT 1");
                            stmt.setString(1, collectorID);
                            res = stmt.executeQuery();
                            if (!res.next()) {
                                n2 = -1;
                                Object var12_10 = null;
                                break block24;
                            }
                            String item_code = res.getString(1);
                            String facilityid = res.getString(2);
                            String cntQuery = "SELECT COUNT(*) FROM cc_calculated_data WHERE collectorid = ? AND item_code = ? AND facilityid = ?";
                            stmt = conn.prepareStatement("SELECT COUNT(*) FROM cc_calculated_data WHERE collectorid = ? AND item_code = ? AND facilityid = ?");
                            stmt.setString(1, collectorID);
                            stmt.setString(2, item_code);
                            stmt.setString(3, facilityid);
                            res = stmt.executeQuery();
                            if (!res.next()) {
                                n = -1;
                                break block25;
                            }
                            ret = res.getInt(1);
                            break block26;
                        }
                        catch (SQLException e) {
                            m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "), (Throwable)e);
                            throw new EJBException(e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        try {
                            if (res != null) {
                                res.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (SQLException e1) {
                            m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "));
                            throw new EJBException(e1.getMessage());
                        }
                        m_log.debug((Object)("recountFromDB() end   :" + collectorID + " "));
                        throw throwable;
                    }
                }
                try {}
                catch (SQLException e1) {
                    m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "));
                    throw new EJBException(e1.getMessage());
                }
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                m_log.debug((Object)("recountFromDB() end   :" + collectorID + " "));
                return n2;
            }
            Object var12_11 = null;
            try {}
            catch (SQLException e1) {
                m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            if (res != null) {
                res.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            m_log.debug((Object)("recountFromDB() end   :" + collectorID + " "));
            return n;
        }
        Object var12_12 = null;
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("recountFromDB() end   :" + collectorID + " "));
        return ret;
    }
}

