/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobSessionJobDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSessionJobDAOImpl
implements JobSessionJobDAO {
    protected static Log m_log = LogFactory.getLog(JobSessionJobDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobSessionJobPK pk, JobSessionJobBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_session_job WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobSessionJob data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                if (res.getTimestamp("end_date") != null) {
                    ejb.setEnd_date(new Date(res.getTimestamp("end_date").getTime()));
                } else {
                    ejb.setEnd_date(null);
                }
                if (res.getString("end_status") != null) {
                    ejb.setEnd_status(res.getInt("end_status"));
                } else {
                    ejb.setEnd_status(null);
                }
                if (res.getString("end_value") != null) {
                    ejb.setEnd_value(res.getInt("end_value"));
                } else {
                    ejb.setEnd_value(null);
                }
                ejb.setEnd_staus_check_flg(res.getInt("end_staus_check_flg"));
                ejb.setJob_id(res.getString("job_id"));
                ejb.setResult(res.getString("result"));
                ejb.setScope_text(res.getString("scope_text"));
                ejb.setSession_id(res.getString("session_id"));
                if (res.getTimestamp("start_date") != null) {
                    ejb.setStart_date(new Date(res.getTimestamp("start_date").getTime()));
                } else {
                    ejb.setStart_date(null);
                }
                ejb.setStatus(res.getInt("status"));
                ejb.setDelay_notify_flg(res.getInt("delay_notify_flg"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobSessionJobBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_session_job SET ");
                sql.append("scope_text = ?, ");
                sql.append("status = ?, ");
                sql.append("start_date = ?, ");
                sql.append("end_date = ?, ");
                sql.append("end_value = ?, ");
                sql.append("end_status = ?, ");
                sql.append("result = ?, ");
                sql.append("end_staus_check_flg = ?, ");
                sql.append("delay_notify_flg = ? ");
                sql.append("WHERE session_id = ? ");
                sql.append("AND job_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getScope_text());
                stmt.setInt(2, ejb.getStatus());
                if (ejb.getStart_date() instanceof Date) {
                    stmt.setTimestamp(3, new Timestamp(ejb.getStart_date().getTime()));
                } else {
                    stmt.setTimestamp(3, null);
                }
                if (ejb.getEnd_date() instanceof Date) {
                    stmt.setTimestamp(4, new Timestamp(ejb.getEnd_date().getTime()));
                } else {
                    stmt.setTimestamp(4, null);
                }
                if (ejb.getEnd_value() instanceof Integer) {
                    stmt.setInt(5, ejb.getEnd_value());
                } else {
                    stmt.setNull(5, 4);
                }
                if (ejb.getEnd_status() instanceof Integer) {
                    stmt.setInt(6, ejb.getEnd_status());
                } else {
                    stmt.setNull(6, 4);
                }
                stmt.setString(7, ejb.getResult());
                stmt.setInt(8, ejb.getEnd_staus_check_flg());
                stmt.setInt(9, ejb.getDelay_notify_flg());
                stmt.setString(10, ejb.getSession_id());
                stmt.setString(11, ejb.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobSessionJobPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_session_job WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobSessionJobPK create(JobSessionJobBean ejb) throws CreateException, EJBException {
        JobSessionJobPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_session_job (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("scope_text, ");
                sql.append("status, ");
                sql.append("start_date, ");
                sql.append("end_date, ");
                sql.append("end_value, ");
                sql.append("end_status, ");
                sql.append("result, ");
                sql.append("end_staus_check_flg, ");
                sql.append("delay_notify_flg) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getSession_id());
                stmt.setString(2, ejb.getJob_id());
                stmt.setString(3, ejb.getScope_text());
                stmt.setInt(4, ejb.getStatus());
                if (ejb.getStart_date() instanceof Date) {
                    stmt.setTimestamp(5, new Timestamp(ejb.getStart_date().getTime()));
                } else {
                    stmt.setTimestamp(5, null);
                }
                if (ejb.getEnd_date() instanceof Date) {
                    stmt.setTimestamp(6, new Timestamp(ejb.getEnd_date().getTime()));
                } else {
                    stmt.setTimestamp(6, null);
                }
                if (ejb.getEnd_value() instanceof Integer) {
                    stmt.setInt(7, ejb.getEnd_value());
                } else {
                    stmt.setNull(7, 4);
                }
                if (ejb.getEnd_status() instanceof Integer) {
                    stmt.setInt(8, ejb.getEnd_status());
                } else {
                    stmt.setNull(8, 4);
                }
                stmt.setString(9, ejb.getResult());
                stmt.setInt(10, ejb.getEnd_staus_check_flg());
                stmt.setInt(11, ejb.getDelay_notify_flg());
                int row = stmt.executeUpdate();
                pk = new JobSessionJobPK(ejb.getSession_id(), ejb.getJob_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobSessionJobPK> ret = new ArrayList<JobSessionJobPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT session_id, job_id FROM cc_job_session_job";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobSessionJobPK pk = new JobSessionJobPK(res.getString("session_id"), res.getString("job_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobSessionJobPK findByPrimaryKey(JobSessionJobPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT session_id, job_id FROM cc_job_session_job WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobSessionJobPK jobSessionJobPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobSessionJobPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findBySessionId(String sessionId) throws FinderException {
        m_log.debug((Object)("findBySessionId() start : " + sessionId));
        ArrayList<JobSessionJobPK> ret = new ArrayList<JobSessionJobPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT session_id, job_id FROM cc_job_session_job WHERE session_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, sessionId);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobSessionJobPK pk = new JobSessionJobPK(res.getString("session_id"), res.getString("job_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findBySessionId() error : " + sessionId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionId() error : " + sessionId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findBySessionId() error : " + sessionId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findBySessionId() end : " + sessionId));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByStatus(Integer status) throws FinderException {
        m_log.debug((Object)("findByStatus() start : " + status));
        ArrayList<JobSessionJobPK> ret = new ArrayList<JobSessionJobPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT a.session_id, a.job_id FROM cc_job_session_job as a, cc_job_session as b ");
                sql.append("WHERE a.session_id = b.session_id AND a.job_id = b.job_id AND ");
                sql.append("a.status = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setInt(1, status);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobSessionJobPK pk = new JobSessionJobPK(res.getString("session_id"), res.getString("job_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByStatus() error : " + status + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByStatus() error : " + status + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByStatus() error : " + status + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByStatus() end : " + status));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        block42: {
            m_log.debug((Object)("makeSession() start : " + sessionId));
            Connection conn = null;
            Connection connMaster = null;
            Statement stmt = null;
            Statement stmtMaster = null;
            String jobId = null;
            try {
                try {
                    conn = ConnectionManager.getConnectionManager().getConnection();
                    connMaster = ConnectionManager.getConnectionManager().getConnection();
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO cc_job_session_job (");
                    sql.append("session_id, ");
                    sql.append("job_id, ");
                    sql.append("scope_text, ");
                    sql.append("status, ");
                    sql.append("start_date, ");
                    sql.append("end_date, ");
                    sql.append("end_value, ");
                    sql.append("end_status, ");
                    sql.append("result, ");
                    sql.append("end_staus_check_flg, ");
                    sql.append("delay_notify_flg) ");
                    sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                    stmt = conn.prepareStatement(sql.toString());
                    stmt.setString(1, sessionId);
                    stmt.setTimestamp(5, null);
                    stmt.setTimestamp(6, null);
                    stmt.setNull(8, 4);
                    stmt.setString(9, null);
                    stmt.setInt(10, 0);
                    stmt.setInt(11, 0);
                    StringBuilder sqlMaster = new StringBuilder();
                    sqlMaster.append("SELECT ");
                    sqlMaster.append("cc_job_mst.job_id, ");
                    sqlMaster.append("cc_job_mst.job_type,");
                    sqlMaster.append("cc_job_command_mst.facility_id, ");
                    sqlMaster.append("cc_job_start_mst.suspend, ");
                    sqlMaster.append("cc_job_start_mst.skip, ");
                    sqlMaster.append("cc_job_start_mst.skip_end_value ");
                    sqlMaster.append("FROM ");
                    sqlMaster.append("(cc_job_mst left join cc_job_start_mst on cc_job_mst.job_id=cc_job_start_mst.job_id ) ");
                    sqlMaster.append("left join cc_job_command_mst on cc_job_mst.job_id=cc_job_command_mst.job_id ");
                    sqlMaster.append("WHERE  cc_job_mst.job_id= ? ");
                    stmtMaster = connMaster.prepareStatement(sqlMaster.toString());
                    RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                    for (Hashtable ht : jobs) {
                        jobId = (String)ht.get("jobId");
                        stmtMaster.setString(1, jobId);
                        ResultSet resMaster = stmtMaster.executeQuery();
                        if (resMaster.next()) {
                            stmt.setString(2, jobId);
                            if (resMaster.getString("facility_id") != null) {
                                String scopePath = repository.getFacilityPath(resMaster.getString("facility_id"), null);
                                stmt.setString(3, scopePath);
                            } else {
                                stmt.setString(3, null);
                            }
                            if (resMaster.getInt("suspend") == 1) {
                                stmt.setInt(4, 1);
                                stmt.setNull(7, 4);
                            } else if (resMaster.getInt("skip") == 1) {
                                stmt.setInt(4, 2);
                                stmt.setInt(7, resMaster.getInt("skip_end_value"));
                            } else {
                                stmt.setInt(4, 0);
                                stmt.setNull(7, 4);
                            }
                            int row = stmt.executeUpdate();
                            if (row != 1) {
                                String msg = "result row is not 1";
                                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                                throw new EJBException(msg);
                            }
                        }
                        resMaster.close();
                    }
                    Object var17_21 = null;
                }
                catch (SQLException e) {
                    if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                    throw new DuplicateKeyException(e.getMessage());
                }
                catch (CreateException e) {
                    e.printStackTrace();
                    Object var17_22 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (stmtMaster != null) {
                            stmtMaster.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        if (connMaster != null) {
                            connMaster.close();
                        }
                    }
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    Object var17_23 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (stmtMaster != null) {
                        stmtMaster.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (connMaster != null) {
                        connMaster.close();
                    }
                    break block42;
                }
                catch (FinderException e) {
                    e.printStackTrace();
                    Object var17_24 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (stmtMaster != null) {
                        stmtMaster.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (connMaster != null) {
                        connMaster.close();
                    }
                    break block42;
                }
            }
            catch (Throwable throwable) {
                Object var17_25 = null;
                try {}
                catch (SQLException e1) {
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            if (stmt != null) {
                stmt.close();
            }
            if (stmtMaster != null) {
                stmtMaster.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (connMaster != null) {
                connMaster.close();
            }
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

