#!/bin/bash

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#ユーザチェック
if [ ! `whoami` = hinemos ]; then
    echo "hinemosユーザで実行してください。"
    exit 1
fi

#設定情報読み込み
. /opt/hinemos/hinemos.cfg

#
#変数
#
SSH_KEYGEN="/usr/bin/ssh-keygen -t rsa"
MKDIR=/bin/mkdir
CHMOD=/bin/chmod

VERSION=`cat ${EXEC_PATH}/hinemos/_version`

echo ""
echo "###################################################################"
echo "###"
echo "###              運用管理ソフトウェア Hinemos"
echo "###            一括制御 セットアップスクリプト  Ver. ${VERSION}"
echo "###"
echo "###  Copyright (C) since 2006 NTT DATA Corporation."
echo "###################################################################"



#hinemosユーザの認証用の公開鍵の作成
setup() {
    echo "" 
    echo "hinemos ユーザの認証用の公開鍵をパスフレーズなしで作成します。"
    echo "よろしいですか? (Y/N default:Y)"
    while [ 1 ];
    do
      read ANS
      ANS=${ANS:-Y}
      case ${ANS} in
          y|Y)
              break
              ;;
          n|N)
              echo "一括制御のセットアップを中止します。"
              sleep 1
              return
              ;;
          *)
              echo "Y か N を入力して下さい。"
              ;;
      esac
    done

    if [ -e ${HOME}/.ssh/id_rsa.pub ]; then
        echo "既に公開鍵が存在します。"
        sleep 1
        return
    fi

    expect -c "
        set timeout 20
        spawn -noecho $SSH_KEYGEN
        expect Enter
        send \r
        expect Enter
        send \r
        expect Enter
        send \r
        expect eof
    "

    if [ $? -ne 0 ] ; then
        echo ""
        echo "公開鍵の作成に失敗しました。"
        echo ""
        break
    fi

    echo ""
    echo "公開鍵を作成しました。"
    echo ""
}


#監視対象ノードへのhinemosユーザの公開鍵の登録
entry() {
    if [ ! -e ${HOME}/.ssh/id_rsa.pub ]; then
        echo ""
        echo "hinemosユーザの公開鍵が作成されていません。作成して下さい。"
        return
    fi
    
    MANAGER_KEY=`cat ${HOME}/.ssh/id_rsa.pub`

    echo ""
    echo ""
    echo "監視対象ノードのrootユーザのauthorized_keysファイルに、hinemosユーザの公開鍵を登録します。"

    while [ 1 ];
    do
        echo ""
        echo "一括制御機能を利用する監視対象ノードのIPアドレスを入力して下さい。"
        echo "終了する場合は、9を入力して下さい。"
        
        read AGENT_IP
        
        case ${AGENT_IP} in
        9)
            break
            ;;
        *)

    
     	    if [ $? -ne 0 ] ; then
		echo ""
		echo "${AGENT_IP} は存在しません。"

	    else
		echo ""
		echo "監視対象ノードのrootユーザのホームディレクトリを指定して下さい。"
		read ROOT_HOME
		
	    #末尾が/でなかったら追加する
		case ${ROOT_HOME} in
		    */)
		        ;;
		    *)
		        ROOT_HOME=${ROOT_HOME}/
			;;
		esac
		
		echo ${ROOT_HOME}".ssh/authorized_keysに、hinemosユーザの公開鍵を設定します。"
		echo "よろしいですか? (Y/N default:Y)"
		read ANS
		ANS=${ANS:-Y}
		AGENT_AUTHORIZED_KEYS=${ROOT_HOME}.ssh/authorized_keys
		case ${ANS} in
		    y|Y)
			ssh root@${AGENT_IP} command "
                            if [ ! -d ${ROOT_HOME}/.ssh ] ; then
                                ${MKDIR} ${ROOT_HOME}/.ssh
                                ${CHMOD} 700 ${ROOT_HOME}/.ssh
                            fi
                            echo ${MANAGER_KEY} >> ${AGENT_AUTHORIZED_KEYS}
                            ${CHMOD} 600 ${AGENT_AUTHORIZED_KEYS}
                        "

			echo ""
			echo "${AGENT_IP} への登録が完了しました。"
		        ;;
		    n|N)
   		        ;;
		    *)
			;;
		esac
	    fi
            sleep 1
            ;;
        esac
    done
}



# main処理
while [ 1 ];
do
    echo ""
    echo "一括制御機能のセットアップ"
    echo ""
    echo "     1) hinemosユーザの認証用の公開鍵の作成"
    echo "     2) 監視対象ノードへの公開鍵登録"
    echo "     9) 一括制御機能のセットアップ終了"
    echo ""
    echo -n "===> "

    read NUMBER

    case ${NUMBER} in
        1)
            setup
            ;;
        2)
            entry
            ;;
        9)
            exit 0
            ;;
        *)
            echo ""
            sleep 1
    esac
done


