/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;

public class OptimizedMethodInvocations
extends OptimizedBehaviourInvocations {
    static String getOptimizedInvocationClassName(CtClass clazz, CtMethod method) {
        long hash = JavassistMethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    public static String getOptimizedInvocationClassName(Method method) throws Exception {
        long hash = MethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(method.getDeclaringClass().getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtMethod method) throws NotFoundException, CannotCompileException {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        String className = OptimizedMethodInvocations.getOptimizedInvocationClassName(clazz, method);
        boolean makeInnerClass = true;
        CtClass invocation = OptimizedMethodInvocations.makeInvocationClass(pool, makeInnerClass, clazz, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        OptimizedMethodInvocations.addArgumentFieldsToInvocation(invocation, params);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
        code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
        code = code + wrappedName + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        if (method.getReturnType().equals(CtClass.voidType)) {
            code = code + " return null; ";
        }
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        OptimizedMethodInvocations.addSetArguments((ClassPool)pool, invocation, method.getParameterTypes());
        OptimizedMethodInvocations.addGetArguments((ClassPool)pool, invocation, method.getParameterTypes(), true);
        OptimizedMethodInvocations.addCopy((ClassPool)pool, invocation, method.getParameterTypes(), isStatic);
        TransformerCommon.compileOrLoadClass(method.getDeclaringClass(), invocation);
        return invocation.getName();
    }

    static void addCopy(ClassPool pool, CtClass invocation, CtClass[] params, boolean isStatic) throws NotFoundException, CannotCompileException {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        StringBuffer code = new StringBuffer("{");
        code.append("   ").append(invocation.getName()).append(" wrapper = new ").append(invocation.getName()).append("(this.interceptors, methodHash, advisedMethod, unadvisedMethod, advisor); ").append("   wrapper.arguments = this.arguments; ").append("   wrapper.metadata = this.metadata; ").append("   wrapper.currentInterceptor = this.currentInterceptor; ").append("   wrapper.instanceResolver = this.instanceResolver; ");
        if (!isStatic) {
            code.append("   wrapper.typedTargetObject = this.typedTargetObject; ");
            code.append("   wrapper.targetObject = this.targetObject; ");
        }
        for (int i = 0; i < params.length; ++i) {
            code.append("   wrapper.arg").append(i).append(" = this.arg").append(i).append("; ");
        }
        code.append("   return wrapper; }");
        copy.setBody(code.toString());
        invocation.addMethod(copy);
    }
}

