/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPConf;
import org.jboss.security.srp.SRPVerifierStore;

public class SerialObjectStore
implements SRPVerifierStore {
    private static Logger log = Logger.getLogger(SerialObjectStore.class);
    private Map infoMap;
    private BigInteger g;
    private BigInteger N;

    public SerialObjectStore() throws IOException {
        this(null);
    }

    public SerialObjectStore(File storeFile) throws IOException {
        if (storeFile == null) {
            storeFile = new File("SerialObjectStore.ser");
        }
        if (storeFile.exists()) {
            FileInputStream fis = new FileInputStream(storeFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                this.infoMap = (Map)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ois.close();
            fis.close();
        } else {
            this.infoMap = Collections.synchronizedMap(new HashMap());
        }
        try {
            Util.init();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IOException("Failed to initialzed security utils: " + e.getMessage());
        }
        this.N = SRPConf.getDefaultParams().N();
        this.g = SRPConf.getDefaultParams().g();
        log.trace((Object)("N: " + Util.tob64((byte[])this.N.toByteArray())));
        log.trace((Object)("g: " + Util.tob64((byte[])this.g.toByteArray())));
        byte[] hn = Util.newDigest().digest(this.N.toByteArray());
        log.trace((Object)("H(N): " + Util.tob64((byte[])hn)));
        byte[] hg = Util.newDigest().digest(this.g.toByteArray());
        log.trace((Object)("H(g): " + Util.tob64((byte[])hg)));
    }

    public SRPVerifierStore.VerifierInfo getUserVerifier(String username) throws KeyException, IOException {
        SRPVerifierStore.VerifierInfo info = null;
        if (this.infoMap != null) {
            info = (SRPVerifierStore.VerifierInfo)this.infoMap.get(username);
        }
        if (info == null) {
            throw new KeyException("username: " + username + " not found");
        }
        return info;
    }

    public void setUserVerifier(String username, SRPVerifierStore.VerifierInfo info) {
        this.infoMap.put(username, info);
    }

    public void verifyUserChallenge(String username, Object auxChallenge) throws SecurityException {
        throw new SecurityException("verifyUserChallenge not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File storeFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(storeFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        Map map = this.infoMap;
        synchronized (map) {
            oos.writeObject(this.infoMap);
        }
        oos.close();
        fos.close();
    }

    public void addUser(String username, String password) {
        log.trace((Object)("addUser, username='" + username + "', password='" + password + "'"));
        SRPVerifierStore.VerifierInfo info = new SRPVerifierStore.VerifierInfo();
        info.username = username;
        String rs = "123456";
        info.salt = rs.getBytes();
        try {
            char[] pass = password.toCharArray();
            info.verifier = Util.calculateVerifier((String)username, (char[])pass, (byte[])info.salt, (BigInteger)this.N, (BigInteger)this.g);
            info.g = this.g.toByteArray();
            info.N = this.N.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace((Object)("N: " + Util.tob64((byte[])info.N)));
                log.trace((Object)("g: " + Util.tob64((byte[])info.g)));
                log.trace((Object)("s: " + Util.tob64((byte[])info.salt)));
                byte[] xb = Util.calculatePasswordHash((String)username, (char[])pass, (byte[])info.salt);
                log.trace((Object)("x: " + Util.tob64((byte[])xb)));
                log.trace((Object)("v: " + Util.tob64((byte[])info.verifier)));
                byte[] hn = Util.newDigest().digest(info.N);
                log.trace((Object)("H(N): " + Util.tob64((byte[])hn)));
                byte[] hg = Util.newDigest().digest(info.g);
                log.trace((Object)("H(g): " + Util.tob64((byte[])hg)));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to calculate verifier", t);
            return;
        }
        this.setUserVerifier(username, info);
    }

    public void delUser(String username) {
        this.infoMap.remove(username);
    }

    public static void main(String[] args) throws IOException {
        File storeFile = new File("SerialObjectStore.ser");
        SerialObjectStore store = new SerialObjectStore();
        for (int a = 0; a < args.length; ++a) {
            if (args[a].startsWith("-a")) {
                store.addUser(args[a + 1], args[a + 2]);
                continue;
            }
            if (!args[a].startsWith("-d")) continue;
            store.delUser(args[a + 1]);
        }
        store.save(storeFile);
    }
}

