/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployerInterceptorSupport;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.wsf.container.jboss42.DeployerHook;
import org.jboss.wsf.container.jboss42.DeployerInterceptorMBean;

public abstract class DeployerInterceptor
extends SubDeployerInterceptorSupport
implements DeployerInterceptorMBean {
    private MainDeployerMBean mainDeployer;
    private List<DeployerHook> phaseOneHooks = new LinkedList<DeployerHook>();
    private List<DeployerHook> phaseTwoHooks = new LinkedList<DeployerHook>();

    public void addPhaseOneHook(DeployerHook hook) {
        this.log.debug((Object)("Add phase-one deployer hook: " + hook));
        this.phaseOneHooks.add(hook);
    }

    public void removePhaseOneHook(DeployerHook hook) {
        this.log.debug((Object)("Remove phase-one deployer hook: " + hook));
        this.phaseOneHooks.remove(hook);
    }

    public void addPhaseTwoHook(DeployerHook hook) {
        this.log.debug((Object)("Add phase-two deployer hook: " + hook));
        this.phaseTwoHooks.add(hook);
    }

    public void removePhaseTwoHook(DeployerHook hook) {
        this.log.debug((Object)("Remove phase-two deployer hook: " + hook));
        this.phaseTwoHooks.remove(hook);
    }

    protected final Object create(Invocation invocation, DeploymentInfo unit) throws Throwable {
        Object retn = this.invokeNext(invocation);
        for (DeployerHook deployer : this.phaseOneHooks) {
            deployer.deploy(unit);
        }
        return retn;
    }

    protected final Object start(Invocation invocation, DeploymentInfo unit) throws Throwable {
        Object retn = this.invokeNext(invocation);
        for (DeployerHook deployer : this.phaseTwoHooks) {
            deployer.deploy(unit);
        }
        return retn;
    }

    protected final Object stop(Invocation invocation, DeploymentInfo unit) throws Throwable {
        Object retn = this.invokeNext(invocation);
        for (DeployerHook deployer : this.phaseTwoHooks) {
            deployer.undeploy(unit);
        }
        return retn;
    }

    protected final Object destroy(Invocation invocation, DeploymentInfo unit) throws Throwable {
        Object retn = this.invokeNext(invocation);
        for (DeployerHook deployer : this.phaseOneHooks) {
            deployer.undeploy(unit);
        }
        return retn;
    }

    protected void createService() throws Exception {
        this.mainDeployer = (MainDeployerMBean)MBeanProxy.get(MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
        super.attach();
    }

    protected void destroyService() {
        super.detach();
    }

    protected void handleStartupException(DeploymentInfo di, Throwable th) {
        this.log.error((Object)("Cannot startup webservice for: " + di.shortName), th);
        this.mainDeployer.undeploy(di);
    }

    protected void handleShutdownException(String moduleName, Throwable th) {
        this.log.error((Object)("Cannot shutdown webservice for: " + moduleName), th);
    }
}

