/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ServerGIOPConnection
extends GIOPConnection {
    private static final byte[] CLOSE_CONNECTION_MESSAGE = new byte[]{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0};
    private final GIOPConnectionManager manager;
    private boolean closeOnReadTimeout = false;
    private boolean delayClose = false;

    public ServerGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener, StatisticsProvider statisticsProvider, GIOPConnectionManager gIOPConnectionManager) {
        super(profile, connection, requestListener, replyListener, statisticsProvider);
        this.manager = gIOPConnectionManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.delayClose = configuration.getAttribute("jacorb.connection.delay_close", "off").equals("on");
    }

    boolean tryClose() {
        if (this.tryDiscard()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": tryClose() -- will send close connection");
            }
            this.sendCloseConnection();
            this.closeOnReadTimeout = true;
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": tryClose() -- cannot close connection");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDiscard() {
        if (!this.hasPendingMessages()) {
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                this.discard_messages = true;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseConnection() {
        try {
            this.getWriteLock();
            this.write(CLOSE_CONNECTION_MESSAGE, 0, CLOSE_CONNECTION_MESSAGE.length);
            this.transport.flush();
            if (this.getStatisticsProviderAdapter() != null) {
                this.getStatisticsProviderAdapter().flushed();
            }
            if (this.delayClose && this.transport instanceof IIOPConnection) {
                ((IIOPConnection)this.transport).turnOnFinalTimeout();
            } else {
                this.do_close = true;
                this.transport.close();
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            this.logger.error("COMM_FAILURE in sendCloseConnection(), in " + this.toString(), (Throwable)cOMM_FAILURE);
        }
        finally {
            this.releaseWriteLock();
        }
        if (this.manager != null) {
            this.manager.unregisterServerGIOPConnection(this);
        }
    }

    protected void readTimedOut() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": readTimedOut()");
        }
        if (this.closeOnReadTimeout) {
            this.close();
        } else {
            this.tryClose();
        }
    }

    protected void streamClosed() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": streamClosed()");
        }
        this.close();
    }

    public void close() {
        super.close();
        if (this.manager != null) {
            this.manager.unregisterServerGIOPConnection(this);
        }
    }

    public String toString() {
        if (this.profile != null) {
            return "ServerGIOPConnection to " + this.profile.toString() + " (" + Integer.toHexString(this.hashCode()) + ")";
        }
        return super.toString();
    }
}

