/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.JAXBBindingCustomization;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.wsf.spi.binding.BindingCustomization;

public class CustomizableJAXBContextFactory
extends JAXBContextFactory {
    public JAXBContext createContext(Class[] clazzes) throws WSException {
        try {
            BindingCustomization customization = this.getCustomization();
            if (null == customization) {
                return JAXBContext.newInstance((Class[])clazzes);
            }
            return JAXBContext.newInstance((Class[])clazzes, (Map)customization);
        }
        catch (JAXBException e) {
            throw new WSException("Failed to create JAXBContext", e);
        }
    }

    public JAXBContext createContext(Class clazz) throws WSException {
        return this.createContext(new Class[]{clazz});
    }

    private BindingCustomization getCustomization() {
        BindingCustomization customization = null;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            for (BindingCustomization current : msgContext.getEndpointMetaData().getBindingCustomizations()) {
                if (!(current instanceof JAXBBindingCustomization)) continue;
                customization = current;
                break;
            }
        }
        return customization;
    }
}

