/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.helpers;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.jboss.console.plugins.helpers.BasePluginWrapper;
import org.jboss.console.plugins.helpers.PluginWrapper;

public class ServletPluginHelper
extends HttpServlet {
    public static final String WRAPPER_CLASS_PARAM = "WrapperClass";
    protected ServletConfig config = null;
    protected PluginWrapper wrapper = null;

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.config = config;
            this.wrapper = this.createPluginWrapper();
            this.wrapper.init(config);
        }
        catch (Throwable e) {
            this.log("Failed to init plugin, " + e.getMessage());
        }
    }

    public void destroy() {
        if (this.wrapper != null) {
            this.wrapper.destroy();
        }
        super.destroy();
    }

    protected PluginWrapper createPluginWrapper() throws Exception {
        String tmp = this.config.getInitParameter(WRAPPER_CLASS_PARAM);
        if (tmp != null && !"".equals(tmp)) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(tmp);
            return (PluginWrapper)clazz.newInstance();
        }
        return new BasePluginWrapper();
    }
}

