/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.loggingmonitor;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;

class MonitoredMBean {
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private String[] attributes;
    private Logger logger;

    public MonitoredMBean(String objectName, String[] attributes, Logger logger) throws MalformedObjectNameException {
        this.objectName = new ObjectName(objectName);
        this.attributes = attributes;
        this.logger = logger;
        this.mbeanServer = MBeanServerLocator.locateJBoss();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logFormat() {
        this.logger.info((Object)this.buildFormatMessage());
    }

    public void logAttributes() throws Exception {
        try {
            StringBuffer message = new StringBuffer();
            for (int j = 0; j < this.attributes.length; ++j) {
                Object attributeValue = this.mbeanServer.getAttribute(this.objectName, this.attributes[j]);
                message.append(attributeValue);
                if (j >= this.attributes.length - 1) continue;
                message.append(",");
            }
            this.logger.info((Object)message);
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
    }

    private String buildFormatMessage() {
        StringBuffer message = new StringBuffer(this.objectName.toString());
        message.append(" monitor format: (");
        for (int i = 0; i < this.attributes.length; ++i) {
            message.append(this.attributes[i]);
            if (i >= this.attributes.length - 1) continue;
            message.append(',');
        }
        message.append(")");
        return message.toString();
    }
}

