/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.system.server.ServerConfigUtil;
import org.w3c.dom.Element;

public class ClusterConfigMetaData
extends MetaData {
    public static final String JNDI_PREFIX_FOR_SESSION_STATE = "/HASessionState/";
    public static final String DEFAULT_SESSION_STATE_NAME = "/HASessionState/Default";
    private String partitionName = ServerConfigUtil.getDefaultPartitionName();
    private String homeLoadBalancePolicy = null;
    private String beanLoadBalancePolicy = null;
    private String haSessionStateName = "/HASessionState/Default";

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getHomeLoadBalancePolicy() {
        return this.homeLoadBalancePolicy;
    }

    public String getBeanLoadBalancePolicy() {
        return this.beanLoadBalancePolicy;
    }

    public String getHaSessionStateName() {
        return this.haSessionStateName;
    }

    public void init(BeanMetaData data) {
        this.homeLoadBalancePolicy = "org.jboss.ha.framework.interfaces.RoundRobin";
        if (this.beanLoadBalancePolicy == null) {
            this.beanLoadBalancePolicy = data.isSession() ? (((SessionMetaData)data).isStateful() ? "org.jboss.ha.framework.interfaces.FirstAvailable" : "org.jboss.ha.framework.interfaces.RoundRobin") : (data.isEntity() ? "org.jboss.ha.framework.interfaces.FirstAvailable" : "org.jboss.ha.framework.interfaces.FirstAvailable");
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        this.partitionName = ClusterConfigMetaData.getElementContent(ClusterConfigMetaData.getOptionalChild(element, "partition-name"), null);
        if (this.partitionName == null) {
            this.partitionName = ServerConfigUtil.getDefaultPartitionName();
        }
        this.homeLoadBalancePolicy = ClusterConfigMetaData.getElementContent(ClusterConfigMetaData.getOptionalChild(element, "home-load-balance-policy"), this.homeLoadBalancePolicy);
        this.beanLoadBalancePolicy = ClusterConfigMetaData.getElementContent(ClusterConfigMetaData.getOptionalChild(element, "bean-load-balance-policy"), this.beanLoadBalancePolicy);
        this.haSessionStateName = ClusterConfigMetaData.getElementContent(ClusterConfigMetaData.getOptionalChild(element, "session-state-manager-jndi-name"), DEFAULT_SESSION_STATE_NAME);
    }
}

