/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class AbandonedObjectPool
extends GenericObjectPool {
    private AbandonedConfig config = null;
    private List trace = new ArrayList();

    public AbandonedObjectPool(PoolableObjectFactory factory, AbandonedConfig config) {
        super(factory);
        this.config = config;
        System.err.println("AbandonedObjectPool is used (" + (Object)((Object)this) + ")");
        System.err.println("   LogAbandoned: " + config.getLogAbandoned());
        System.err.println("   RemoveAbandoned: " + config.getRemoveAbandoned());
        System.err.println("   RemoveAbandonedTimeout: " + config.getRemoveAbandonedTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        Object obj;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((obj = super.borrowObject()) instanceof AbandonedTrace) {
            ((AbandonedTrace)obj).setStackTrace();
        }
        if (obj != null && this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.add(obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.remove(obj);
            }
        }
        super.returnObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.remove(obj);
            }
        }
        super.invalidateObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        PoolableConnection pc;
        Iterator it;
        long now = System.currentTimeMillis();
        long timeout = now - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<PoolableConnection> remove = new ArrayList<PoolableConnection>();
        List list = this.trace;
        synchronized (list) {
            it = this.trace.iterator();
            while (it.hasNext()) {
                pc = (PoolableConnection)it.next();
                if (pc.getLastUsed() > timeout || pc.getLastUsed() <= 0L) continue;
                remove.add(pc);
            }
        }
        it = ((AbstractList)remove).iterator();
        while (it.hasNext()) {
            pc = (PoolableConnection)it.next();
            if (this.config.getLogAbandoned()) {
                pc.printStackTrace();
            }
            try {
                this.invalidateObject(pc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

