/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.engines.xslt.XSLTResultNode;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XSLTEngine
extends BSFEngineImpl {
    TransformerFactory tFactory;
    Transformer transformer;

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        throw new BSFException(BSFException.REASON_UNSUPPORTED_FEATURE, "BSF:XSLTEngine can't call methods");
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.transformer.setParameter(bSFDeclaredBean.name, new XObject(bSFDeclaredBean.bean));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        Object object2;
        Source source;
        block16: {
            block17: {
                Object object3 = this.mgr.lookupBean("xslt:styleBaseURI");
                String string2 = object3 == null ? "." : object3.toString();
                StreamSource streamSource = new StreamSource(new StringReader(object.toString()));
                streamSource.setSystemId(string2);
                try {
                    this.transformer = this.tFactory.newTransformer(streamSource);
                }
                catch (Exception exception) {
                    exception.printStackTrace(DebugLog.getDebugStream());
                    throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception from Xerces XSLT: " + exception, exception);
                }
                Object object4 = this.mgr.lookupBean("xslt:src");
                source = null;
                if (object4 == null) break block17;
                if (object4 instanceof Node) {
                    source = new DOMSource((Node)object4);
                    break block16;
                } else {
                    try {
                        String string3 = "as anything";
                        if (object4 instanceof Reader) {
                            source = new StreamSource((Reader)object4);
                            string3 = "as a Reader";
                        } else if (object4 instanceof File) {
                            source = new StreamSource((File)object4);
                            string3 = "as a file";
                        } else {
                            object2 = object4.toString();
                            source = new StreamSource(new StringReader((String)object2));
                            if (object4 instanceof URL) {
                                string3 = "as a URL";
                            } else {
                                ((StreamSource)source).setPublicId((String)object2);
                                string3 = "as an XML string";
                            }
                        }
                        if (source == null) {
                            throw new Exception("Unable to get input from '" + object4 + "' " + string3);
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "BSF:XSLTEngine: unable to get input from '" + object4 + "' as XML", exception);
                    }
                }
            }
            source = new StreamSource();
        }
        for (int i = 0; i < this.declaredBeans.size(); ++i) {
            object2 = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
            this.transformer.setParameter(((BSFDeclaredBean)object2).name, new XObject(((BSFDeclaredBean)object2).bean));
        }
        this.transformer.setParameter("bsf", new XObject((Object)new BSFFunctions(this.mgr, this)));
        try {
            DOMResult dOMResult = new DOMResult();
            this.transformer.transform((StreamSource)source, dOMResult);
            return new XSLTResultNode(dOMResult.getNode());
        }
        catch (Exception exception) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "exception while eval'ing XSLT script" + exception, exception);
        }
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.tFactory = TransformerFactory.newInstance();
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.transformer.getParameter(bSFDeclaredBean.name) != null) {
            this.transformer.setParameter(bSFDeclaredBean.name, null);
        }
    }
}

