/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advised;

public class Util {
    private static final Set immediates = new HashSet<Object>(Arrays.asList(String.class, Boolean.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Boolean.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, Class.class));

    public static String getRealId(String sessionId) {
        int index = sessionId.lastIndexOf(".");
        if (index > 0) {
            return sessionId.substring(0, index);
        }
        return sessionId;
    }

    public static boolean checkPojoType(Object pojo) {
        return pojo instanceof Serializable || pojo instanceof Collection || pojo instanceof Map || pojo instanceof Advised || immediates.contains(pojo.getClass());
    }

    public static Set parseComplexFields(Class clazz) {
        HashSet<String> result = new HashSet<String>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (immediates.contains(fields[i].getType()) || !Util.isReplicatable(fields[i])) continue;
                result.add(fields[i].getName());
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static boolean isReplicatable(Field f) {
        int mods = f.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && !Modifier.isFinal(mods);
    }

    private Util() {
    }
}

