/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;

public class PrincipalSessionAttributeFilter
implements Filter {
    private static Logger log = Logger.getLogger(PrincipalSessionAttributeFilter.class);
    private boolean trace = log.isTraceEnabled();
    private static final String JBOSS_PRINCIPAL = "org.jboss.web.tomcat.security.principal";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)request).getSession();
        Principal principal = (Principal)session.getAttribute(JBOSS_PRINCIPAL);
        if (principal == null) {
            principal = ((HttpServletRequest)request).getUserPrincipal();
            session.setAttribute(JBOSS_PRINCIPAL, (Object)principal);
            if (this.trace) {
                log.trace((Object)"Placing principal in session");
            }
        }
    }
}

