/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable;

import com.clustercontrol.sharedtable.DataTable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableHolder {
    private Object modifyLock = new Object();
    private ArrayList<DataTable> m_list;
    private String m_checkKey = null;
    private final int m_pageSize;

    public DataTableHolder(int pageSize) {
        this.m_pageSize = pageSize;
        this.m_list = new ArrayList(pageSize);
        for (int i = 0; i < this.m_pageSize; ++i) {
            this.m_list.add(new DataTable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDataTable(DataTable table, String checkKey) {
        Object object = this.modifyLock;
        synchronized (object) {
            DataTable lastTable = this.m_list.get(0);
            if (lastTable != null && lastTable.getCreateTime() > table.getCreateTime()) {
                return;
            }
            if (this.m_checkKey == null) {
                this.m_checkKey = checkKey;
            }
            if (!this.m_checkKey.equals(checkKey)) {
                this.m_list.clear();
                for (int i = 0; i < this.m_pageSize - 1; ++i) {
                    this.m_list.add(new DataTable());
                }
                this.m_checkKey = checkKey;
            }
            if (this.m_list.size() == this.m_pageSize) {
                this.m_list.remove(this.m_pageSize - 1);
            }
            this.m_list.add(0, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable get(int page) {
        Object object = this.modifyLock;
        synchronized (object) {
            if (this.m_list.size() <= page) {
                return null;
            }
            return this.m_list.get(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataTable> getLast(int pageSize) {
        Object object = this.modifyLock;
        synchronized (object) {
            if (this.m_list.size() < pageSize) {
                return null;
            }
            ArrayList<DataTable> list = new ArrayList<DataTable>(this.m_pageSize);
            list.addAll(this.m_list.subList(0, pageSize));
            return list;
        }
    }

    public int getPageSize() {
        return this.m_pageSize;
    }
}

