/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.util;

import com.clustercontrol.ping.util.PingProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReachAddressFping {
    protected static Log m_log = LogFactory.getLog(ReachAddressFping.class);
    public static String fpingPath;
    public static String fping6Path;
    private int m_sentCount = PingProperties.getFpingCount();
    private int m_sentInterval = PingProperties.getFpingInterval();
    private int m_timeout = PingProperties.getFpingTimeout();
    private ArrayList m_errMsg;
    private ArrayList m_resultMsg;

    public ReachAddressFping(int sentNum, int sentInterval, int timeout) {
        this.m_sentCount = sentNum;
        this.m_sentInterval = sentInterval;
        this.m_timeout = timeout;
        PingProperties.getProperties();
        fpingPath = PingProperties.getFpingPath();
        fping6Path = PingProperties.getFping6Path();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReachable(ArrayList hosts, int version) {
        Process process = null;
        int m_exitValue = 0;
        int length = 5 + hosts.size();
        String[] cmd = new String[length];
        cmd[0] = version == 6 ? fping6Path : fpingPath;
        cmd[1] = "-C" + this.m_sentCount;
        cmd[2] = "-p" + this.m_sentInterval;
        cmd[3] = "-t" + this.m_timeout;
        cmd[4] = "-q";
        for (int i = 0; i < hosts.size(); ++i) {
            cmd[i + 5] = (String)hosts.get(i);
        }
        try {
            process = Runtime.getRuntime().exec(cmd);
            if (process != null) {
                StreamReader errStreamReader = new StreamReader(process.getErrorStream());
                errStreamReader.start();
                StreamReader inStreamReader = new StreamReader(process.getInputStream());
                inStreamReader.start();
                m_exitValue = process.waitFor();
                inStreamReader.join();
                this.m_resultMsg = inStreamReader.getResult();
                m_log.debug((Object)("isReachable() :" + inStreamReader.getResult().toString()));
                errStreamReader.join();
                this.m_errMsg = errStreamReader.getResult();
                m_log.debug((Object)("isReachable() :" + errStreamReader.getResult().toString()));
            }
        }
        catch (IOException e) {
            this.m_errMsg = new ArrayList();
            this.m_errMsg.add(e.getMessage());
            m_log.error((Object)("isReachable() :" + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            this.m_errMsg = new ArrayList();
            this.m_errMsg.add(e.getMessage());
            m_log.error((Object)("isReachable() :" + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return m_exitValue == 0 || m_exitValue == 1;
    }

    public ArrayList getM_errMsg() {
        return this.m_errMsg;
    }

    public ArrayList getM_resultMsg() {
        return this.m_resultMsg;
    }

    class StreamReader
    extends Thread {
        BufferedReader m_br;
        ArrayList m_ret;
        InputStream m_ist;

        public StreamReader(InputStream ist) {
            this.m_br = new BufferedReader(new InputStreamReader(ist));
            this.m_ist = ist;
            this.m_ret = new ArrayList();
        }

        public void run() {
            try {
                String outputString;
                while ((outputString = this.m_br.readLine()) != null) {
                    this.m_ret.add(outputString);
                }
            }
            catch (IOException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                this.m_ist.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public ArrayList getResult() {
            return this.m_ret;
        }
    }
}

