/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonClient;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.RoleSource;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.SchemaGenerator;
import org.jboss.ws.core.jaxrpc.UnqualifiedCallParameter;
import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;
import org.jboss.ws.core.jaxrpc.handler.HandlerChainBaseImpl;
import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallImpl
extends CommonClient
implements Call,
RoleSource {
    private static Logger log = Logger.getLogger(CallImpl.class);
    private ServiceImpl jaxrpcService;
    private QName portType;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final Set<String> standardProperties = new HashSet<String>();

    CallImpl(ServiceImpl service) {
        super(service.getServiceMetaData());
        this.jaxrpcService = service;
        if (this.epMetaData != null) {
            this.setTargetEndpointAddress(this.epMetaData.getEndpointAddress());
        }
    }

    CallImpl(ServiceImpl service, EndpointMetaData epMetaData) {
        super(epMetaData);
        this.jaxrpcService = service;
        this.setTargetEndpointAddress(epMetaData.getEndpointAddress());
    }

    CallImpl(ServiceImpl service, QName portName, QName opName) throws ServiceException {
        super(service.getServiceMetaData(), portName, opName);
        this.jaxrpcService = service;
        if (this.epMetaData != null) {
            this.setTargetEndpointAddress(this.epMetaData.getEndpointAddress());
        }
    }

    public ServiceImpl getServiceImpl() {
        return this.jaxrpcService;
    }

    @Override
    protected Map<String, Object> getRequestContext() {
        return this.properties;
    }

    @Override
    public String getTargetEndpointAddress() {
        return (String)this.properties.get("javax.xml.rpc.service.endpoint.address");
    }

    @Override
    public void setTargetEndpointAddress(String address) {
        this.properties.put("javax.xml.rpc.service.endpoint.address", address);
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        TypeMappingImpl typeMapping = this.getEndpointMetaData().getServiceMetaData().getTypeMapping();
        Class<?> javaType = typeMapping.getJavaType(xmlType);
        if (javaType == null) {
            log.warn((Object)("Register unqualified call parameter for: " + xmlType));
            javaType = new UnqualifiedCallParameter(xmlType).getClass();
            typeMapping.register(javaType, xmlType, null, null);
        }
        this.addParameter(paramName, xmlType, javaType, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode mode) {
        QName xmlName = new QName(paramName);
        this.addParameter(xmlName, xmlType, javaType, mode, false);
    }

    public void addParameter(QName xmlName, QName xmlType, Class javaType, ParameterMode mode, boolean inHeader) {
        if (xmlType == null || javaType == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaType.getName());
        paramMetaData.setMode(mode);
        paramMetaData.setInHeader(inHeader);
        paramMetaData.setIndex(opMetaData.getParameters().size());
        opMetaData.addParameter(paramMetaData);
        this.registerParameterType(xmlType, javaType);
    }

    public void removeAllParameters() {
        OperationMetaData opMetaData = this.getOperationMetaData();
        opMetaData.removeAllParameters();
    }

    public void setReturnType(QName xmlType) {
        Class javaType = this.getEndpointMetaData().getServiceMetaData().getTypeMapping().getJavaType(xmlType);
        this.setReturnType(xmlType, javaType);
    }

    public void setReturnType(QName xmlType, Class javaType) {
        if (xmlType == null || javaType == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        QName xmlName = new QName("result");
        String javaTypeName = javaType.getName();
        ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
        opMetaData.setReturnParameter(retMetaData);
        this.registerParameterType(xmlType, javaType);
    }

    public void invokeOneWay(Object[] inputParams) {
        try {
            this.invokeInternal(this.operationName, inputParams, true);
        }
        catch (RemoteException ex) {
            throw new JAXRPCException((Throwable)ex);
        }
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        return this.invokeInternal(this.operationName, inputParams, false);
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        return this.invokeInternal(operationName, inputParams, false);
    }

    @Override
    protected CommonMessageContext processPivot(CommonMessageContext requestContext) {
        return MessageContextJAXRPC.processPivot(requestContext);
    }

    public List getOutputValues() {
        if (this.epInv == null) {
            throw new JAXRPCException("Output params not available");
        }
        try {
            OperationMetaData opMetaData = this.getOperationMetaData();
            List<Object> objPayload = new ArrayList<Object>();
            for (QName xmlName : this.epInv.getResponseParamNames()) {
                Object paramValue = this.epInv.getResponseParamValue(xmlName);
                if (opMetaData.isDocumentWrapped()) {
                    objPayload = Arrays.asList((Object[])paramValue);
                    break;
                }
                objPayload.add(paramValue);
            }
            return objPayload;
        }
        catch (SOAPException ex) {
            throw new JAXRPCException("Cannot obtain response payload", (Throwable)ex);
        }
    }

    public Map getOutputParams() {
        if (this.epInv == null) {
            throw new JAXRPCException("Output params not available");
        }
        try {
            LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
            for (QName xmlName : this.epInv.getResponseParamNames()) {
                Object value = this.epInv.getResponseParamValue(xmlName);
                outMap.put(xmlName.getLocalPart(), value);
            }
            return outMap;
        }
        catch (SOAPException ex) {
            throw new JAXRPCException("Cannot obtain response payload", (Throwable)ex);
        }
    }

    public QName getPortTypeName() {
        if (this.portType != null) {
            return this.portType;
        }
        return new QName("");
    }

    public QName getReturnType() {
        OperationMetaData opDesc;
        ParameterMetaData retMetaData;
        QName retType = null;
        if (this.operationName != null && (retMetaData = (opDesc = this.getOperationMetaData()).getReturnParameter()) != null) {
            retType = retMetaData.getXmlType();
        }
        return retType;
    }

    public void setPortTypeName(QName portType) {
        this.portType = portType;
    }

    public boolean isParameterAndReturnSpecRequired(QName opName) {
        this.setOperationName(opName);
        OperationMetaData opMetaData = this.getOperationMetaData();
        return opMetaData.getParameters().size() == 0 && opMetaData.getReturnParameter() == null;
    }

    public Iterator getPropertyNames() {
        return standardProperties.iterator();
    }

    public Object getProperty(String name) {
        if (null == name) {
            throw new JAXRPCException("Unsupported property: " + name);
        }
        if (name.startsWith("javax.xml.rpc") && !standardProperties.contains(name)) {
            throw new JAXRPCException("Unsupported property: " + name);
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (null == name) {
            throw new JAXRPCException("Unsupported property: " + name);
        }
        if (name.startsWith("javax.xml.rpc") && !standardProperties.contains(name)) {
            throw new JAXRPCException("Unsupported property: " + name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty: [name=" + name + ",value=" + value + "]"));
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public QName getParameterTypeByName(String paramName) {
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData paramMetaData = opMetaData.getParameter(new QName(paramName));
        if (paramMetaData != null) {
            return paramMetaData.getXmlType();
        }
        return null;
    }

    @Override
    protected CommonBindingProvider getCommonBindingProvider() {
        if (this.bindingProvider == null) {
            this.bindingProvider = new CommonBindingProvider(this.getEndpointMetaData());
        }
        return this.bindingProvider;
    }

    @Override
    protected void setInboundContextProperties() {
    }

    @Override
    protected void setOutboundContextProperties() {
    }

    private Object invokeInternal(QName opName, Object[] inputParams, boolean forceOneway) throws RemoteException {
        if (!opName.equals(this.operationName)) {
            this.setOperationName(opName);
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        this.generateOrUpdateSchemas(opMetaData);
        SOAPMessageContextJAXRPC msgContext = new SOAPMessageContextJAXRPC();
        MessageContextAssociation.pushMessageContext(msgContext);
        Object retObj = null;
        try {
            Object object = retObj = super.invoke(opName, inputParams, forceOneway);
            return object;
        }
        catch (SOAPFaultException ex) {
            log.error((Object)"Call invocation failed", (Throwable)ex);
            String faultCode = ex.getFaultCode().getLocalPart();
            throw new RemoteException("Call invocation failed with code [" + faultCode + "] because of: " + ex.getFaultString(), ex);
        }
        catch (RemoteException rex) {
            throw rex;
        }
        catch (WSTimeoutException toex) {
            throw toex;
        }
        catch (Exception ex) {
            throw new RemoteException("Call invocation failed", ex);
        }
        finally {
            MessageContextAssociation.popMessageContext();
        }
    }

    @Override
    protected boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        boolean status;
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
        boolean bl = status = handlerChain != null ? handlerChain.handleRequest(msgContext, type) : true;
        if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            XOPContext.visitAndRestoreXOPData();
        }
        return status;
    }

    @Override
    protected boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
        boolean status = true;
        if (handlerChain != null) {
            status = handlerChain.handleResponse(msgContext, type);
        }
        return status;
    }

    @Override
    protected boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
        boolean status = true;
        if (handlerChain != null) {
            status = handlerChain.handleFault(msgContext, type);
        }
        return status;
    }

    @Override
    protected void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
    }

    private void generateOrUpdateSchemas(OperationMetaData opMetaData) {
        ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
        if (serviceMetaData.getWsdlLocation() == null) {
            TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                this.generateOrUpdateParameterSchema(typesMetaData, paramMetaData);
            }
            ParameterMetaData retMetaData = opMetaData.getReturnParameter();
            if (retMetaData != null) {
                this.generateOrUpdateParameterSchema(typesMetaData, retMetaData);
            }
        }
    }

    private void generateOrUpdateParameterSchema(TypesMetaData typesMetaData, ParameterMetaData paramMetaData) {
        if (!paramMetaData.isSwA()) {
            QName xmlType = paramMetaData.getXmlType();
            Class javaType = paramMetaData.getJavaType();
            ServiceMetaData serviceMetaData = this.getEndpointMetaData().getServiceMetaData();
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            SerializerFactory serFactory = typeMapping.getSerializer(javaType, xmlType);
            if (serFactory instanceof JBossXBSerializerFactory) {
                SchemaGenerator xsdGenerator = new SchemaGenerator();
                JBossXSModel model = xsdGenerator.generateXSDSchema(xmlType, javaType);
                typesMetaData.addSchemaModel(model);
            }
        }
    }

    private void registerParameterType(QName xmlType, Class javaType) {
        ServiceMetaData serviceMetaData = this.getEndpointMetaData().getServiceMetaData();
        String nsURI = xmlType.getNamespaceURI();
        if (!"http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI)) {
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            Class regJavaType = typeMapping.getJavaType(xmlType);
            if (regJavaType == null) {
                typeMapping.register(javaType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
            } else if (regJavaType != null && !JavaUtils.isAssignableFrom(regJavaType, javaType)) {
                throw new IllegalArgumentException("Different java type already registered: " + regJavaType.getName());
            }
        }
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        epMetaData.setConfigName(configName, configFile);
        this.jaxrpcService.setupHandlerChain(epMetaData);
    }

    @Override
    public Set<QName> getHeaders() {
        HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(this.epMetaData.getPortName());
        return handlerChain != null ? handlerChain.getHeaders() : new HashSet<QName>();
    }

    @Override
    public Set<String> getRoles() {
        HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(this.epMetaData.getPortName());
        HashSet<String> set = new HashSet<String>();
        String[] roles = handlerChain.getRoles();
        if (roles != null) {
            Collections.addAll(set, roles);
        }
        return set;
    }

    @Override
    protected boolean shouldMaintainSession() {
        Object bool = this.getRequestContext().get("javax.xml.rpc.session.maintain");
        return Boolean.TRUE.equals(bool);
    }

    static {
        standardProperties.add("javax.xml.rpc.encodingstyle.namespace.uri");
        standardProperties.add("javax.xml.rpc.soap.operation.style");
        standardProperties.add("javax.xml.rpc.session.maintain");
        standardProperties.add("javax.xml.rpc.soap.http.soapaction.uri");
        standardProperties.add("javax.xml.rpc.soap.http.soapaction.use");
        standardProperties.add("javax.xml.rpc.security.auth.username");
        standardProperties.add("javax.xml.rpc.security.auth.password");
        standardProperties.add("javax.xml.rpc.service.endpoint.address");
        standardProperties.add("javax.xml.rpc.session.maintain");
        standardProperties.add("javax.xml.rpc.security.auth.username");
        standardProperties.add("javax.xml.rpc.security.auth.password");
    }
}

