/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class ContextServlet
extends HttpServlet {
    protected final Logger log = Logger.getLogger(ContextServlet.class);
    protected EndpointRegistry epRegistry;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter writer = res.getWriter();
        res.setContentType("text/html");
        writer.print("<html>");
        this.setupHTMLResponseHeader(writer);
        URL requestURL = new URL(req.getRequestURL().toString());
        writer.print("<body>");
        writer.print("<div class='pageHeader'>JBossWS/Services</div>");
        writer.print("<div class='pageSection'>");
        writer.print("<fieldset>");
        writer.print("<legend><b>Registered Service Endpoints</b></legend>");
        writer.print("<table>");
        Set epNames = this.epRegistry.getEndpoints();
        if (epNames.isEmpty()) {
            writer.print("<tr>");
            writer.print("\t<td><h3>There are currently no endpoints deployed</h3></td>");
            writer.print("</tr>");
        }
        for (ObjectName oname : epNames) {
            Endpoint ep = this.epRegistry.getEndpoint(oname);
            writer.print("<tr>");
            writer.print("\t<td>Endpoint Name</td>");
            writer.print("\t<td>" + ep.getName() + "</td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>Endpoint Address</td>");
            writer.print("\t<td><a href='" + ep.getAddress() + "?wsdl'>" + ep.getAddress() + "?wsdl</a></td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td colspan=2>");
            writer.print("\t");
            writer.print("");
            EndpointMetrics metrics = ep.getEndpointMetrics();
            if (metrics != null) {
                writer.print("<table class='metrics'>");
                writer.print("<tr>");
                writer.print(" <td>StartTime</td>");
                writer.print(" <td>StopTime</td>");
                writer.print(" <td></td>");
                writer.print("</tr>");
                writer.print("<tr>");
                writer.print(" <td>" + metrics.getStartTime() + "</td>");
                String stopTime = metrics.getStopTime() != null ? metrics.getStopTime().toString() : "";
                writer.print(" <td>" + stopTime + "</td>");
                writer.print(" <td></td>");
                writer.print("</tr>");
                writer.print("<tr>");
                writer.print(" <td>RequestCount</td>");
                writer.print(" <td>ResponseCount</td>");
                writer.print(" <td>FaultCount</td>");
                writer.print("</tr>");
                writer.print("<tr>");
                writer.print(" <td>" + metrics.getRequestCount() + "</td>");
                writer.print(" <td>" + metrics.getResponseCount() + "</td>");
                writer.print(" <td>" + metrics.getFaultCount() + "</td>");
                writer.print("</tr>");
                writer.print("<tr>");
                writer.print(" <td>MinProcessingTime</td>");
                writer.print(" <td>MaxProcessingTime</td>");
                writer.print(" <td>AvgProcessingTime</td>");
                writer.print("</tr>");
                writer.print("<tr>");
                writer.print(" <td>" + metrics.getMinProcessingTime() + "</td>");
                writer.print(" <td>" + metrics.getMaxProcessingTime() + "</td>");
                writer.print(" <td>" + metrics.getAverageProcessingTime() + "</td>");
                writer.print("</tr>");
                writer.print("");
                writer.print("");
                writer.print("</table>");
                writer.print("");
            }
            writer.print("\t</td>");
            writer.print("</tr>");
            writer.print("<tr><td colspan='3'>&nbsp;</td></tr>");
        }
        writer.print("</table>");
        writer.print("");
        writer.print("</fieldset>");
        writer.print("</div>");
        writer.print("</body>");
        writer.print("</html>");
        writer.close();
    }

    private void setupHTMLResponseHeader(PrintWriter writer) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        writer.println("<head>");
        writer.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        writer.println("<title>JBossWS / " + serverConfig.getImplementationVersion() + "</title>");
        writer.println("<link rel='stylesheet' href='./styles.css'>");
        writer.println("</head>");
    }
}

